/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.RawEntry;
import com.gigaspaces.query.aggregators.OrderBy;
import com.gigaspaces.query.aggregators.OrderByKey;
import com.gigaspaces.query.aggregators.OrderByPath;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class OrderByAggregator<T>
extends SpaceEntriesAggregator<OrderByScanResult>
implements Externalizable {
    private transient SpaceEntriesAggregatorContext context;
    private static final long serialVersionUID = 1L;
    private transient SortedMap<OrderByKey, ArrayList<RawEntry>> map;
    private transient OrderByKey key;
    private int limit = Integer.MAX_VALUE;
    private transient int aggregatedCount = 0;
    private List<OrderByPath> orderByPaths = new LinkedList<OrderByPath>();

    public OrderByAggregator() {
    }

    public OrderByAggregator(int limit) {
        this.limit = limit;
    }

    public OrderByAggregator orderBy(String path, OrderBy orderBy) {
        return this.orderBy(path, orderBy, false);
    }

    public OrderByAggregator orderBy(String path) {
        return this.orderBy(path, OrderBy.ASC, false);
    }

    public OrderByAggregator orderBy(String path, OrderBy orderBy, boolean nullsLast) {
        this.orderByPaths.add(new OrderByPath(path, orderBy, nullsLast));
        return this;
    }

    @Override
    public String getDefaultAlias() {
        return "order by (" + this.orderByPaths.toString() + ")";
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        this.context = context;
        if (this.map == null) {
            this.map = new TreeMap<OrderByKey, ArrayList<RawEntry>>();
            this.key = new OrderByKey(this.orderByPaths.size());
        }
        if (!this.key.initialize(this.orderByPaths, this.context)) {
            return;
        }
        if (this.map.get(this.key) == null) {
            this.map.put((OrderByKey)this.key.clone(), new ArrayList());
        }
        ((ArrayList)this.map.get(this.key)).add(context.getRawEntry());
        ++this.aggregatedCount;
        if (this.aggregatedCount > this.limit) {
            this.removeLastEntry();
            --this.aggregatedCount;
        }
    }

    @Override
    public void aggregateIntermediateResult(OrderByScanResult partitionResult) {
        if (this.map == null) {
            this.map = new TreeMap<OrderByKey, ArrayList<RawEntry>>();
        }
        if (partitionResult.getResultMap() == null) {
            return;
        }
        for (Map.Entry<OrderByKey, ArrayList<RawEntry>> entry : partitionResult.getResultMap().entrySet()) {
            ArrayList<RawEntry> entryList = entry.getValue();
            ArrayList currentEntryList = (ArrayList)this.map.get(entry.getKey());
            if (currentEntryList == null) {
                this.map.put(entry.getKey(), entryList);
            } else {
                currentEntryList.addAll(entryList);
            }
            this.aggregatedCount += entryList.size();
            while (this.aggregatedCount > this.limit) {
                this.removeLastEntry();
                --this.aggregatedCount;
            }
        }
    }

    @Override
    public OrderByScanResult getIntermediateResult() {
        OrderByScanResult orderByResult = new OrderByScanResult();
        if (this.map != null) {
            for (List list : this.map.values()) {
                for (RawEntry entry : list) {
                    this.context.applyProjectionTemplate(entry);
                }
            }
            orderByResult.setResultMap(this.map);
        }
        return orderByResult;
    }

    @Override
    public Collection<T> getFinalResult() {
        ArrayList<Object> list = new ArrayList<Object>(this.aggregatedCount);
        if (this.map == null) {
            return list;
        }
        for (List list2 : this.map.values()) {
            for (RawEntry entry : list2) {
                list.add(this.toObject(entry));
            }
        }
        return list;
    }

    private void removeLastEntry() {
        ArrayList lastEntries = (ArrayList)this.map.get(this.map.lastKey());
        RawEntry r = (RawEntry)lastEntries.remove(lastEntries.size() - 1);
        if (lastEntries.isEmpty()) {
            this.map.remove(this.map.lastKey());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this.orderByPaths);
        out.writeInt(this.limit);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderByPaths = (List)IOUtils.readObject(in);
        this.limit = in.readInt();
    }

    public static class OrderByScanResult
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Map<OrderByKey, ArrayList<RawEntry>> resultMap;

        public Map<OrderByKey, ArrayList<RawEntry>> getResultMap() {
            return this.resultMap;
        }

        public void setResultMap(Map<OrderByKey, ArrayList<RawEntry>> resultMap) {
            this.resultMap = resultMap;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeObject(out, this.resultMap);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.resultMap = (Map)IOUtils.readObject(in);
        }
    }
}

