/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.query.CompoundResult;
import com.gigaspaces.query.aggregators.OrderBy;
import com.gigaspaces.query.aggregators.OrderByPath;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderByKey
extends CompoundResult
implements Comparable<OrderByKey> {
    private static final long serialVersionUID = 1L;
    private List<OrderByPath> orderByPaths;

    public OrderByKey() {
    }

    public OrderByKey(Object[] values) {
        super(values, null);
    }

    protected OrderByKey(int numOfValues) {
        super(new Object[numOfValues], null);
    }

    protected boolean initialize(List<OrderByPath> orderByPaths, SpaceEntriesAggregatorContext context) {
        this.orderByPaths = orderByPaths;
        this.nameIndexMap = new HashMap();
        this.hashCode = 0;
        for (int i = 0; i < orderByPaths.size(); ++i) {
            this.values[i] = context.getPathValue(orderByPaths.get(i).getPath());
            this.nameIndexMap.put(orderByPaths.get(i).getPath(), i);
        }
        return true;
    }

    protected void setNameIndex(Map<String, Integer> nameIndexMap) {
        this.nameIndexMap = nameIndexMap;
    }

    @Override
    public int compareTo(OrderByKey orderKey) {
        int rc = 0;
        for (int i = 0; i < this.orderByPaths.size(); ++i) {
            Comparable c2;
            OrderByPath orderByPath = this.orderByPaths.get(i);
            Comparable c1 = (Comparable)this.get(orderByPath.getPath());
            if (c1 == (c2 = (Comparable)orderKey.get(orderByPath.getPath()))) continue;
            if (c1 == null) {
                return orderByPath.isNullsLast() ? 1 : -1;
            }
            if (c2 == null) {
                return orderByPath.isNullsLast() ? -1 : 1;
            }
            rc = c1.compareTo(c2);
            if (rc == 0) continue;
            return orderByPath.getOrderBy() == OrderBy.DESC ? -rc : rc;
        }
        return rc;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this.orderByPaths);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.orderByPaths = (List)IOUtils.readObject(in);
    }
}

