/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.query.RawEntry;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class SpaceEntriesAggregatorContext {
    private final Collection<SpaceEntriesAggregator> aggregators;
    private final Map<String, Object> pathCache;

    protected SpaceEntriesAggregatorContext(Collection<SpaceEntriesAggregator> aggregators) {
        this.aggregators = aggregators;
        this.pathCache = aggregators.size() > 1 ? new HashMap() : null;
    }

    public Object getPathValue(String path) {
        if (this.pathCache == null) {
            return this.getPathValueImpl(path);
        }
        if (this.pathCache.containsKey(path)) {
            return this.pathCache.get(path);
        }
        Object value = this.getPathValueImpl(path);
        this.pathCache.put(path, value);
        return value;
    }

    public abstract int getPartitionId();

    public abstract String getEntryUid();

    public abstract RawEntry getRawEntry();

    public abstract void applyProjectionTemplate(RawEntry var1);

    protected abstract Object getPathValueImpl(String var1);

    protected void aggregate() {
        if (this.pathCache != null) {
            this.pathCache.clear();
        }
        for (SpaceEntriesAggregator aggregator : this.aggregators) {
            aggregator.aggregate(this);
        }
    }
}

