/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.utils.math.MutableNumber;
import com.gigaspaces.query.aggregators.AbstractPathAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;

public class SumAggregator
extends AbstractPathAggregator<MutableNumber> {
    private static final long serialVersionUID = 1L;
    private transient MutableNumber result;

    @Override
    public String getDefaultAlias() {
        return "sum(" + this.getPath() + ")";
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        this.add((Number)this.getPathValue(context));
    }

    @Override
    public MutableNumber getIntermediateResult() {
        return this.result;
    }

    @Override
    public void aggregateIntermediateResult(MutableNumber partitionResult) {
        if (this.result == null) {
            this.result = partitionResult;
        } else {
            this.result.add(partitionResult.toNumber());
        }
    }

    @Override
    public Object getFinalResult() {
        return this.result != null ? (Number)this.result.toNumber() : (Number)null;
    }

    private void add(Number number) {
        if (number != null) {
            if (this.result == null) {
                this.result = MutableNumber.fromClass(number.getClass(), true);
            }
            this.result.add(number);
        }
    }
}

