/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.extension.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.extension.QueryExtensionProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class QueryExtensionProviderCache {
    private static final Map<String, QueryExtensionProvider> cache = new ConcurrentHashMap<String, QueryExtensionProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryExtensionProvider getByClass(Class<? extends QueryExtensionProvider> providerClass) {
        QueryExtensionProvider result = cache.get(providerClass.getName());
        if (result == null) {
            Map<String, QueryExtensionProvider> map = cache;
            synchronized (map) {
                result = cache.get(providerClass.getName());
                if (result == null) {
                    try {
                        result = providerClass.newInstance();
                        cache.put(providerClass.getName(), result);
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException("Failed to create SpaceQueryExtensionProvider from " + providerClass.getName(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Failed to create SpaceQueryExtensionProvider from " + providerClass.getName(), e);
                    }
                }
            }
        }
        return result;
    }
}

