/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.extension.metadata.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.query.extension.metadata.QueryExtensionPathInfo;
import com.gigaspaces.query.extension.metadata.TypeQueryExtension;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@InternalApi
public class TypeQueryExtensionImpl
implements TypeQueryExtension,
Externalizable {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<QueryExtensionPathInfo>> propertiesInfo = new HashMap<String, List<QueryExtensionPathInfo>>();

    public void add(String path, QueryExtensionPathInfo queryExtensionPathInfo) {
        if (!this.propertiesInfo.containsKey(path)) {
            this.propertiesInfo.put(path, new ArrayList());
        }
        this.propertiesInfo.get(path).add(queryExtensionPathInfo);
    }

    @Override
    public List<QueryExtensionPathInfo> get(String path) {
        return this.propertiesInfo.get(path);
    }

    @Override
    public Set<String> getPaths() {
        return this.propertiesInfo.keySet();
    }

    @Override
    public boolean isIndexed(String path) {
        List<QueryExtensionPathInfo> pathInfos = this.propertiesInfo.get(path);
        if (pathInfos == null) {
            return false;
        }
        for (QueryExtensionPathInfo pathInfo : pathInfos) {
            if (!pathInfo.isIndexed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            this.writeExternal_v12_1(out);
        } else {
            this.writeExternal_v12_0(out);
        }
    }

    private void writeExternal_v12_1(ObjectOutput out) throws IOException {
        out.writeInt(this.propertiesInfo.size());
        for (Map.Entry<String, List<QueryExtensionPathInfo>> entry : this.propertiesInfo.entrySet()) {
            IOUtils.writeString(out, entry.getKey());
            IOUtils.writeList(out, entry.getValue());
        }
    }

    private void writeExternal_v12_0(ObjectOutput out) throws IOException {
        out.writeInt(this.propertiesInfo.size());
        for (Map.Entry<String, List<QueryExtensionPathInfo>> entry : this.propertiesInfo.entrySet()) {
            IOUtils.writeString(out, entry.getKey());
            IOUtils.writeObject(out, entry.getValue().get(0));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            this.readExternal_v12_1(in);
        } else {
            this.readExternal_v12_0(in);
        }
    }

    private void readExternal_v12_1(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = IOUtils.readString(in);
            List value = IOUtils.readList(in);
            this.propertiesInfo.put(key, value);
        }
    }

    private void readExternal_v12_0(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = IOUtils.readString(in);
            QueryExtensionPathInfo value = (QueryExtensionPathInfo)IOUtils.readObject(in);
            this.propertiesInfo.put(key, Collections.singletonList(value));
        }
    }
}

