/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.extension.metadata.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.query.extension.QueryExtensionProvider;
import com.gigaspaces.query.extension.SpaceQueryExtension;
import com.gigaspaces.query.extension.impl.QueryExtensionProviderCache;
import com.gigaspaces.query.extension.metadata.DefaultQueryExtensionPathInfo;
import com.gigaspaces.query.extension.metadata.QueryExtensionPathInfo;
import com.gigaspaces.query.extension.metadata.QueryExtensionPropertyInfo;
import com.gigaspaces.query.extension.metadata.TypeQueryExtension;
import com.gigaspaces.query.extension.metadata.TypeQueryExtensions;
import com.gigaspaces.query.extension.metadata.impl.TypeQueryExtensionImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class TypeQueryExtensionsImpl
implements TypeQueryExtensions,
Externalizable {
    private static final long serialVersionUID = 1L;
    private final Map<String, TypeQueryExtensionImpl> info = new HashMap<String, TypeQueryExtensionImpl>();

    public TypeQueryExtensionsImpl() {
    }

    public TypeQueryExtensionsImpl(SpaceTypeInfo typeInfo) {
        for (SpacePropertyInfo property : typeInfo.getSpaceProperties()) {
            for (Annotation annotation : property.getGetterMethod().getDeclaredAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(SpaceQueryExtension.class)) continue;
                QueryExtensionProvider provider = this.extractQueryExtensionProvider(annotation);
                QueryExtensionPropertyInfo propertyInfo = provider.getPropertyExtensionInfo(property.getName(), annotation);
                for (String path : propertyInfo.getPaths()) {
                    this.add(provider.getNamespace(), path, propertyInfo.getPathInfo(path));
                }
            }
        }
    }

    private QueryExtensionProvider extractQueryExtensionProvider(Annotation annotation) {
        SpaceQueryExtension spaceQueryExtension = annotation.annotationType().getAnnotation(SpaceQueryExtension.class);
        return QueryExtensionProviderCache.getByClass(spaceQueryExtension.providerClass());
    }

    public void add(String path, Class<? extends Annotation> annotationType) {
        String namespace = this.getNamespace(annotationType);
        this.add(namespace, path, new DefaultQueryExtensionPathInfo());
    }

    public void add(String path, QueryExtensionPathInfo queryExtensionPathInfo) {
        String namespace = QueryExtensionProviderCache.getByClass(queryExtensionPathInfo.getQueryExtensionProviderClass()).getNamespace();
        this.add(namespace, path, queryExtensionPathInfo);
    }

    private void add(String namespace, String path, QueryExtensionPathInfo queryExtensionPathInfo) {
        TypeQueryExtensionImpl typeQueryExtension = this.getOrCreateTypeQueryExtension(namespace);
        typeQueryExtension.add(path, queryExtensionPathInfo);
    }

    private String getNamespace(Class<? extends Annotation> annotationType) {
        if (!annotationType.isAnnotationPresent(SpaceQueryExtension.class)) {
            throw new IllegalArgumentException("Annotation " + annotationType + " is not a space query extension annotation");
        }
        SpaceQueryExtension spaceQueryExtension = annotationType.getAnnotation(SpaceQueryExtension.class);
        return QueryExtensionProviderCache.getByClass(spaceQueryExtension.providerClass()).getNamespace();
    }

    @Override
    public boolean isIndexed(String namespace, String path) {
        TypeQueryExtension typeQueryExtension = this.info.get(namespace);
        return typeQueryExtension != null && typeQueryExtension.isIndexed(path);
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.info.keySet();
    }

    @Override
    public TypeQueryExtension getByNamespace(String namespace) {
        return this.info.get(namespace);
    }

    private TypeQueryExtensionImpl getOrCreateTypeQueryExtension(String namespace) {
        TypeQueryExtensionImpl typeQueryExtension = this.info.get(namespace);
        if (typeQueryExtension == null) {
            typeQueryExtension = new TypeQueryExtensionImpl();
            this.info.put(namespace, typeQueryExtension);
        }
        return typeQueryExtension;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.info.size());
        for (Map.Entry<String, TypeQueryExtensionImpl> entry : this.info.entrySet()) {
            IOUtils.writeString(out, entry.getKey());
            entry.getValue().writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = IOUtils.readString(in);
            TypeQueryExtensionImpl value = new TypeQueryExtensionImpl();
            value.readExternal(in);
            this.info.put(key, value);
        }
    }
}

