/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.sql.functions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.query.sql.functions.SqlFunctionExecutionContext;

@InternalApi
public class AbsSqlFunction
extends SqlFunction {
    @Override
    public Object apply(SqlFunctionExecutionContext context) {
        this.assertNumberOfArguments(1, context);
        Object arg = context.getArgument(0);
        if (arg instanceof Integer) {
            return Math.abs((Integer)arg);
        }
        if (arg instanceof Long) {
            return Math.abs((Long)arg);
        }
        if (arg instanceof Float) {
            return Float.valueOf(Math.abs(((Float)arg).floatValue()));
        }
        if (arg instanceof Double) {
            return Math.abs((Double)arg);
        }
        if (arg instanceof Short) {
            Integer abs = Math.abs(((Short)arg).shortValue());
            return abs.shortValue();
        }
        if (arg instanceof Byte) {
            Integer abs = Math.abs(((Byte)arg).byteValue());
            return abs.byteValue();
        }
        throw new RuntimeException("Abs function - wrong argument type: " + arg);
    }
}

