/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.sql.functions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.query.sql.functions.SqlFunctionExecutionContext;

@InternalApi
public class FloorSqlFunction
extends SqlFunction {
    @Override
    public Object apply(SqlFunctionExecutionContext context) {
        this.assertNumberOfArguments(1, context);
        Object arg = context.getArgument(0);
        if (!(arg instanceof Number)) {
            throw new RuntimeException("Floor function - wrong argument type, should be a Number - : " + arg);
        }
        if (arg instanceof Double) {
            return Math.floor((Double)arg);
        }
        if (arg instanceof Float) {
            return Float.valueOf((float)Math.floor(((Float)arg).floatValue()));
        }
        if (arg instanceof Long) {
            return arg;
        }
        if (arg instanceof Integer) {
            return arg;
        }
        if (arg instanceof Short) {
            return arg;
        }
        if (arg instanceof Byte) {
            return arg;
        }
        throw new RuntimeException("Floor function - wrong argument type - unsupported Number type: " + arg);
    }
}

