/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.sql.functions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.query.sql.functions.SqlFunctionExecutionContext;

@InternalApi
public class RoundSqlFunction
extends SqlFunction {
    @Override
    public Object apply(SqlFunctionExecutionContext context) {
        Object arg = context.getArgument(0);
        Integer decimalPlaces = 0;
        if (context.getNumberOfArguments() >= 2) {
            decimalPlaces = (Integer)context.getArgument(1);
        }
        if (!(arg instanceof Number)) {
            throw new RuntimeException("Round function - wrong argument type, should be type Number - : " + arg);
        }
        double factor = Math.pow(10.0, decimalPlaces.intValue());
        if (arg instanceof Double) {
            long res = Math.round((Double)arg * factor);
            return (double)res / factor;
        }
        if (arg instanceof Float) {
            long res = Math.round((double)((Float)arg).floatValue() * factor);
            return Float.valueOf(new Double((double)res / factor).floatValue());
        }
        return arg;
    }
}

