/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.sql.functions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.query.sql.functions.SqlFunctionExecutionContext;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

@InternalApi
public class ToCharSqlFunction
extends SqlFunction {
    @Override
    public Object apply(SqlFunctionExecutionContext context) {
        Object arg = context.getArgument(0);
        Object format = null;
        if (context.getNumberOfArguments() >= 2) {
            format = context.getArgument(1);
        }
        if (arg instanceof Number) {
            if (format != null) {
                DecimalFormat decimalFormat = new DecimalFormat(String.valueOf(format));
                return decimalFormat.format(arg);
            }
            return arg;
        }
        if (arg instanceof Date) {
            if (format != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(String.valueOf(format));
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                return sdf.format(arg);
            }
            return arg;
        }
        throw new RuntimeException("To_Char function - wrong argument type: " + arg);
    }
}

