/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.sql.functions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.query.sql.functions.SqlFunctionExecutionContext;
import java.text.DecimalFormat;

@InternalApi
public class ToNumberSqlFunction
extends SqlFunction {
    @Override
    public Object apply(SqlFunctionExecutionContext context) {
        Object arg = context.getArgument(0);
        Object format = null;
        if (context.getNumberOfArguments() >= 2) {
            format = context.getArgument(1);
        }
        if (arg instanceof String && ToNumberSqlFunction.isNumeric(String.valueOf(arg))) {
            String str = String.valueOf(arg);
            if (format != null) {
                if (str.contains(".")) {
                    DecimalFormat formatter = new DecimalFormat(String.valueOf(format));
                    double number = Double.parseDouble(String.valueOf(arg));
                    String numberFormatted = formatter.format(number);
                    return Double.parseDouble(numberFormatted);
                }
                DecimalFormat formatter = new DecimalFormat(String.valueOf(format));
                int number = Integer.parseInt(String.valueOf(arg));
                String numberFormatted = formatter.format(number);
                return Integer.parseInt(numberFormatted);
            }
            if (str.contains(".")) {
                return Double.parseDouble(str);
            }
            return Integer.parseInt(str);
        }
        throw new RuntimeException("To_Number function - wrong argument type: " + arg);
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }
}

