/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security;

import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.authorities.SystemAuthority;

public final class AuthorityFactory {
    public static Authority create(String authority) {
        String[] split = authority.split(" ");
        if (split.length < 2) {
            throw new IllegalArgumentException("Illegal Authority format: " + authority);
        }
        String privilege = split[0];
        if (RoleAuthority.RolePrivilege.class.getSimpleName().equals(privilege)) {
            return RoleAuthority.valueOf(authority);
        }
        if (SystemAuthority.SystemPrivilege.class.getSimpleName().equals(privilege)) {
            return SystemAuthority.valueOf(authority);
        }
        if (SpaceAuthority.SpacePrivilege.class.getSimpleName().equals(privilege)) {
            return SpaceAuthority.valueOf(authority);
        }
        if (GridAuthority.GridPrivilege.class.getSimpleName().equals(privilege)) {
            return GridAuthority.valueOf(authority);
        }
        if (MonitorAuthority.MonitorPrivilege.class.getSimpleName().equals(privilege)) {
            return MonitorAuthority.valueOf(authority);
        }
        throw new IllegalArgumentException("Unknown authority type; Could not create an Authority from: " + authority);
    }
}

