/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security;

import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.SecurityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecurityFactory {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.security");
    public static final String DEFAULT_SECURITY_RESOURCE = "security.properties";
    public static final String DEFAULT_SECURITY_DIRECTORY = "config/security/";
    private static final String DEFAULT_SECURITY_MANAGER_CLASS_REFERENCE_IMPL = "com.gigaspaces.security.fs.FileSecurityManager";

    public static SecurityManager createSecurityManager(Properties securityProperties) {
        try {
            String property;
            if (securityProperties == null) {
                securityProperties = new Properties();
            }
            if (logger.isLoggable(Level.CONFIG) && (property = securityProperties.getProperty("com.gs.security.security-manager.class")) != null) {
                logger.config("Security security-manager class: " + property);
            }
            String classname = securityProperties.getProperty("com.gs.security.security-manager.class", DEFAULT_SECURITY_MANAGER_CLASS_REFERENCE_IMPL).trim();
            Class<SecurityManager> securityManagerClass = Thread.currentThread().getContextClassLoader().loadClass(classname).asSubclass(SecurityManager.class);
            SecurityManager securityManager = securityManagerClass.newInstance();
            securityManager.init(securityProperties);
            return securityManager;
        }
        catch (Exception e) {
            throw new SecurityException("Failed to create Security Manager", e);
        }
    }

    public static Properties loadSecurityProperties(String resourceName) {
        InputStream resourceAsStream = SecurityFactory.findSecurityProperties(resourceName);
        try {
            if (resourceAsStream == null) {
                throw new FileNotFoundException("Could not locate resource [" + resourceName + "] or the default [" + DEFAULT_SECURITY_RESOURCE + "] in the classpath or under [" + DEFAULT_SECURITY_DIRECTORY + "] directory.");
            }
            Properties props = new Properties();
            props.load(resourceAsStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new SecurityException("Failed to load security properties file", e);
        }
        finally {
            try {
                if (resourceAsStream != null) {
                    resourceAsStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Properties loadComponentSecurityProperties(String component, boolean useMinusDLast) {
        InputStream resourceStream;
        Properties securityProperties = new Properties();
        String fullName = component + "-" + DEFAULT_SECURITY_RESOURCE;
        String securityPropertyFile = System.getProperty("com.gs.security.properties-file", fullName);
        if (useMinusDLast) {
            resourceStream = SecurityFactory.findSecurityProperties(fullName);
            if (resourceStream == null) {
                resourceStream = SecurityFactory.findSecurityProperties(securityPropertyFile);
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "found security properties file by matching the component name [ " + fullName + " ]");
                }
            }
        } else {
            resourceStream = SecurityFactory.findSecurityProperties(securityPropertyFile);
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "found security property by matching the sys-prop provided name[ " + securityPropertyFile + " ]");
            }
        }
        if (resourceStream != null) {
            try {
                securityProperties.load(resourceStream);
            }
            catch (IOException e) {
                throw new SecurityException("Failed to load security properties file", e);
            }
            finally {
                try {
                    resourceStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String property = System.getProperty("com.gs.security.properties-file");
        if (property != null) {
            throw new SecurityException("Failed to locate security properties file specified via system property: -Dcom.gs.security.properties-file=" + property);
        }
        return securityProperties;
    }

    public static InputStream findSecurityProperties(String resourceName) {
        InputStream resourceAsStream = null;
        if (resourceName != null) {
            File file = new File(resourceName);
            if (file.exists()) {
                try {
                    resourceAsStream = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Should not happen", e);
                }
            } else {
                resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
                if (resourceAsStream == null) {
                    resourceName = DEFAULT_SECURITY_DIRECTORY + resourceName;
                    resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
                }
            }
        }
        if (resourceAsStream == null) {
            resourceName = DEFAULT_SECURITY_RESOURCE;
            resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (resourceAsStream == null) {
                resourceName = "config/security/security.properties";
                resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            }
        }
        if (resourceAsStream != null && logger.isLoggable(Level.CONFIG)) {
            logger.config("Security properties file: " + resourceName);
        }
        return resourceAsStream;
    }
}

