/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.authorities;

import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.authorities.PopulatedRoleAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.authorities.SpaceAuthority;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GrantedAuthorities
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Privilege, List<Authority>> authorityMap;
    private final Set<String> roles;

    public GrantedAuthorities(Authority[] authorities) {
        HashMap map = new HashMap();
        HashSet<String> rolesSet = new HashSet<String>();
        ArrayList<Authority> normalizedAuthorities = new ArrayList<Authority>(authorities.length);
        for (Authority authority : authorities) {
            if (authority instanceof PopulatedRoleAuthority) {
                PopulatedRoleAuthority roleWrapper = (PopulatedRoleAuthority)authority;
                rolesSet.add(roleWrapper.getRole());
                for (Authority roleAuthority : roleWrapper.getAuthorities()) {
                    GrantedAuthorities.add(roleAuthority, normalizedAuthorities);
                }
                continue;
            }
            GrantedAuthorities.add(authority, normalizedAuthorities);
        }
        for (Authority authority : normalizedAuthorities) {
            Privilege key = ((InternalAuthority)authority).getPrivilege();
            ArrayList<Authority> list = (ArrayList<Authority>)map.get(key);
            list = list == null ? new ArrayList<Authority>(1) : new ArrayList(list);
            list.add(authority);
            map.put(key, Collections.unmodifiableList(list));
        }
        this.authorityMap = Collections.unmodifiableMap(map);
        this.roles = Collections.unmodifiableSet(rolesSet);
    }

    private static void add(Authority authority, List<Authority> authorities) {
        authorities.add(authority);
        if (authority instanceof SpaceAuthority && ((SpaceAuthority)authority).getPrivilege() == SpaceAuthority.SpacePrivilege.WRITE) {
            authorities.add(new SpaceAuthority(SpaceAuthority.SpacePrivilege.CREATE, ((SpaceAuthority)authority).getFilter()));
        }
    }

    public boolean isGranted(Privilege privilege) {
        List<Authority> list = this.authorityMap.get(privilege);
        return list != null;
    }

    public boolean isGranted(Privilege privilege, Object object) {
        List<Authority> list = this.authorityMap.get(privilege);
        if (list == null) {
            return false;
        }
        if (!privilege.getClass().equals(SpaceAuthority.SpacePrivilege.class)) {
            return true;
        }
        Boolean include = null;
        Boolean exclude = null;
        for (Authority grantedAuthority : list) {
            SpaceAuthority authority = (SpaceAuthority)grantedAuthority;
            SpaceAuthority.Filter filter = authority.getFilter();
            if (filter == null) {
                include = Boolean.TRUE;
                continue;
            }
            boolean accept = filter.accept(object);
            if (filter instanceof SpaceAuthority.NegateFilter) {
                exclude = exclude == null ? Boolean.valueOf(accept) : exclude != false && accept;
                continue;
            }
            include = include == null ? Boolean.valueOf(accept) : include != false || accept;
        }
        include = include == null ? Boolean.TRUE : include;
        exclude = exclude == null ? Boolean.TRUE : exclude;
        return include != false && exclude != false;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }
}

