/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.authorities;

import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.authorities.Privilege;

public class GridAuthority
implements InternalAuthority {
    private static final long serialVersionUID = 1L;
    private final GridPrivilege gridPrivilege;

    public GridAuthority(GridPrivilege gridPrivilege) {
        this.gridPrivilege = gridPrivilege;
    }

    public static GridAuthority valueOf(String authority) {
        if (authority == null) {
            throw new IllegalArgumentException("Illegal Authority format: null");
        }
        String[] split = authority.split(" ");
        if (split.length < 2) {
            throw new IllegalArgumentException("Illegal Authority format: " + authority);
        }
        if (!GridPrivilege.class.getSimpleName().equals(split[0])) {
            throw new IllegalArgumentException("Illegal Privilege name in: " + authority);
        }
        GridPrivilege gridPrivilege = GridPrivilege.valueOf(split[1]);
        return new GridAuthority(gridPrivilege);
    }

    @Override
    public String getAuthority() {
        return this.gridPrivilege.getClass().getSimpleName() + " " + this.gridPrivilege.name();
    }

    public String toString() {
        return this.getAuthority();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAuthority() == null ? 0 : this.getAuthority().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridAuthority other = (GridAuthority)obj;
        return !(this.getAuthority() == null ? other.getAuthority() != null : !this.getAuthority().equals(other.getAuthority()));
    }

    @Override
    public Privilege getPrivilege() {
        return this.gridPrivilege;
    }

    public static enum GridPrivilege implements Privilege
    {
        PROVISION_PU,
        MANAGE_PU,
        MANAGE_GRID;


        public String toString() {
            switch (this) {
                case PROVISION_PU: {
                    return "Provision PU";
                }
                case MANAGE_PU: {
                    return "Manage PU";
                }
                case MANAGE_GRID: {
                    return "Manage Grid";
                }
            }
            return super.toString();
        }
    }
}

