/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.authorities;

import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.authorities.Privilege;

public class MonitorAuthority
implements InternalAuthority {
    private static final long serialVersionUID = 1L;
    private final MonitorPrivilege monitorPrivilege;

    public MonitorAuthority(MonitorPrivilege monitorPrivilege) {
        this.monitorPrivilege = monitorPrivilege;
    }

    public static MonitorAuthority valueOf(String authority) {
        if (authority == null) {
            throw new IllegalArgumentException("Illegal Authority format: null");
        }
        String[] split = authority.split(" ");
        if (split.length < 2) {
            throw new IllegalArgumentException("Illegal Authority format: " + authority);
        }
        if (!MonitorPrivilege.class.getSimpleName().equals(split[0])) {
            throw new IllegalArgumentException("Illegal Privilege name in: " + authority);
        }
        MonitorPrivilege monitorPrivilege = MonitorPrivilege.valueOf(split[1]);
        return new MonitorAuthority(monitorPrivilege);
    }

    @Override
    public String getAuthority() {
        return this.monitorPrivilege.getClass().getSimpleName() + " " + this.monitorPrivilege.name();
    }

    public String toString() {
        return this.getAuthority();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAuthority() == null ? 0 : this.getAuthority().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonitorAuthority other = (MonitorAuthority)obj;
        return !(this.getAuthority() == null ? other.getAuthority() != null : !this.getAuthority().equals(other.getAuthority()));
    }

    @Override
    public Privilege getPrivilege() {
        return this.monitorPrivilege;
    }

    public static enum MonitorPrivilege implements Privilege
    {
        MONITOR_JVM,
        MONITOR_PU;


        public String toString() {
            switch (this) {
                case MONITOR_JVM: {
                    return "Monitor JVM";
                }
                case MONITOR_PU: {
                    return "Monitor PU";
                }
            }
            return super.toString();
        }
    }
}

