/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.authorities;

import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.Privilege;

public class RoleAuthority
implements Authority {
    private static final long serialVersionUID = 1L;
    private final String role;

    public RoleAuthority(String role) {
        this.role = role;
    }

    public static RoleAuthority valueOf(String authority) {
        if (authority == null) {
            throw new IllegalArgumentException("Illegal Authority format: null");
        }
        String[] split = authority.split(" ");
        if (split.length < 2) {
            throw new IllegalArgumentException("Illegal Authority format: " + authority);
        }
        if (!RolePrivilege.class.getSimpleName().equals(split[0])) {
            throw new IllegalArgumentException("Illegal Privilege name in: " + authority);
        }
        String role = split[1];
        return new RoleAuthority(role);
    }

    @Override
    public String getAuthority() {
        return RolePrivilege.class.getSimpleName() + " " + this.role;
    }

    public String toString() {
        return this.getAuthority();
    }

    public String getRole() {
        return this.role;
    }

    public static enum RolePrivilege implements Privilege
    {

    }
}

