/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.authorities;

import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.authorities.Privilege;
import java.io.Serializable;
import java.util.regex.Pattern;

public class SpaceAuthority
implements InternalAuthority {
    private static final long serialVersionUID = 1L;
    private final SpacePrivilege spacePrivilege;
    private final Filter filter;

    public SpaceAuthority(SpacePrivilege spacePrivilege) {
        this(spacePrivilege, null);
    }

    public SpaceAuthority(SpacePrivilege spacePrivilege, Filter filter) {
        this.spacePrivilege = spacePrivilege;
        this.filter = filter;
    }

    public static SpaceAuthority valueOf(String authority) {
        if (authority == null) {
            throw new IllegalArgumentException("Illegal Authority format: null");
        }
        String[] split = authority.split(" ");
        if (split.length < 2) {
            throw new IllegalArgumentException("Illegal Authority format: " + authority);
        }
        if (!SpacePrivilege.class.getSimpleName().equals(split[0])) {
            throw new IllegalArgumentException("Illegal Privilege name in: " + authority);
        }
        SpacePrivilege spacePrivilege = SpacePrivilege.valueOf(split[1]);
        Filter<String> filter = null;
        if (split.length > 2) {
            String filterClass = split[2];
            String filterParams = authority.substring(authority.indexOf(split[3]));
            if (filterClass.equals(PackageFilter.class.getSimpleName())) {
                filter = new PackageFilter(filterParams);
            } else if (filterClass.equals(NegatePackageFilter.class.getSimpleName())) {
                filter = new NegatePackageFilter(filterParams);
            } else if (filterClass.equals(ClassFilter.class.getSimpleName())) {
                filter = new ClassFilter(filterParams);
            } else if (filterClass.equals(NegateClassFilter.class.getSimpleName())) {
                filter = new NegateClassFilter(filterParams);
            } else if (filterClass.equals(RegexFilter.class.getSimpleName())) {
                filter = new RegexFilter(filterParams);
            } else {
                throw new IllegalArgumentException("Unknown authority representation.");
            }
        }
        return new SpaceAuthority(spacePrivilege, filter);
    }

    @Override
    public String getAuthority() {
        return this.spacePrivilege.getClass().getSimpleName() + " " + this.spacePrivilege.name() + (this.filter == null ? "" : " " + this.filter);
    }

    public String toString() {
        return this.getAuthority();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAuthority() == null ? 0 : this.getAuthority().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpaceAuthority other = (SpaceAuthority)obj;
        return !(this.getAuthority() == null ? other.getAuthority() != null : !this.getAuthority().equals(other.getAuthority()));
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Privilege getPrivilege() {
        return this.spacePrivilege;
    }

    public static class WildcardExpressionToFilterConverter {
        public static Filter<?> convert(String expression, boolean allow) {
            if (!WildcardExpressionToFilterConverter.isPattern(expression)) {
                if (allow) {
                    ClassFilter filter = new ClassFilter(expression);
                    return filter;
                }
                NegateClassFilter filter = new NegateClassFilter(expression);
                return filter;
            }
            if (WildcardExpressionToFilterConverter.isPackagePattern(expression) && !WildcardExpressionToFilterConverter.isRegexPattern(expression)) {
                String packageName = expression.substring(0, expression.length() - 2);
                if (allow) {
                    PackageFilter filter = new PackageFilter(packageName);
                    return filter;
                }
                NegatePackageFilter filter = new NegatePackageFilter(packageName);
                return filter;
            }
            return WildcardExpressionToFilterConverter.convertToRegex(expression, allow);
        }

        public static Filter<?> convertToRegex(String expression, boolean allow) {
            String toRegex = expression.replace(".", "\\.").replace("*", ".*");
            if (allow) {
                RegexFilter filter = new RegexFilter(toRegex);
                return filter;
            }
            NegateRegexFilter filter = new NegateRegexFilter(toRegex);
            return filter;
        }

        private static boolean isRegexPattern(String expression) {
            return expression.indexOf(92) != -1;
        }

        private static boolean isPackagePattern(String expression) {
            return expression.endsWith(".*") && expression.indexOf(42) == expression.length() - 1;
        }

        private static boolean isPattern(String expression) {
            return expression.indexOf(42) != -1 || expression.indexOf(63) != -1;
        }
    }

    public static final class NegateClassFilter
    extends ClassFilter
    implements NegateFilter<String> {
        private static final long serialVersionUID = 1L;

        public NegateClassFilter(String className) {
            super(className);
        }

        @Override
        public boolean accept(String otherClassName) {
            return !super.accept(otherClassName);
        }
    }

    public static class ClassFilter
    implements Filter<String> {
        private static final long serialVersionUID = 1L;
        private final String className;
        private final String expression;

        public ClassFilter(String className) {
            this.className = className;
            this.expression = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.className;
        }

        @Override
        public boolean accept(String otherClassName) {
            if (otherClassName == null) {
                return false;
            }
            return this.className.equals(otherClassName);
        }

        @Override
        public String getExpression() {
            return this.expression;
        }
    }

    public static final class NegatePackageFilter
    extends PackageFilter
    implements NegateFilter<String> {
        private static final long serialVersionUID = 1L;

        public NegatePackageFilter(String packagename) {
            super(packagename);
        }

        @Override
        public boolean accept(String otherPackageName) {
            return !super.accept(otherPackageName);
        }
    }

    public static class PackageFilter
    implements Filter<String> {
        private static final long serialVersionUID = 1L;
        private final String packageName;
        private final String expression;

        public PackageFilter(String packagename) {
            this.packageName = packagename;
            this.expression = packagename + ".*";
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.packageName;
        }

        @Override
        public boolean accept(String other) {
            if (other == null) {
                return false;
            }
            return other.startsWith(this.packageName);
        }

        @Override
        public String getExpression() {
            return this.expression;
        }
    }

    public static final class NegateRegexFilter
    extends RegexFilter
    implements NegateFilter<String> {
        private static final long serialVersionUID = 1L;

        public NegateRegexFilter(String regex) {
            super(regex);
        }

        @Override
        public boolean accept(String otherRegex) {
            return !super.accept(otherRegex);
        }
    }

    public static class RegexFilter
    implements Filter<String> {
        private static final long serialVersionUID = 1L;
        private final String regex;
        private final Pattern pattern;
        private final String expression;

        public RegexFilter(String regex) {
            this.regex = regex;
            this.pattern = Pattern.compile(regex);
            this.expression = regex.replace("\\.", ".").replace(".*", "*");
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.regex;
        }

        @Override
        public boolean accept(String otherRegex) {
            if (otherRegex == null) {
                otherRegex = "*";
            }
            return this.pattern.matcher(otherRegex).matches();
        }

        @Override
        public String getExpression() {
            return this.expression;
        }
    }

    public static interface NegateFilter<T>
    extends Filter<T> {
    }

    public static interface Filter<T>
    extends Serializable {
        public String getExpression();

        public boolean accept(T var1);
    }

    public static enum SpacePrivilege implements Privilege
    {
        NOT_SET,
        WRITE,
        READ,
        TAKE,
        EXECUTE,
        ALTER,
        CREATE;


        public String toString() {
            switch (this) {
                case WRITE: {
                    return "Write";
                }
                case READ: {
                    return "Read";
                }
                case TAKE: {
                    return "Take";
                }
                case EXECUTE: {
                    return "Execute";
                }
                case ALTER: {
                    return "Alter";
                }
                case CREATE: {
                    return "Create";
                }
            }
            return super.toString();
        }
    }
}

