/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.authorities;

import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.authorities.Privilege;

public class SystemAuthority
implements InternalAuthority {
    private static final long serialVersionUID = 1L;
    private final SystemPrivilege systemPrivilege;

    public SystemAuthority(SystemPrivilege systemPrivilege) {
        this.systemPrivilege = systemPrivilege;
    }

    public static SystemAuthority valueOf(String authority) {
        String[] split = authority.split(" ");
        if (split.length < 2) {
            throw new IllegalArgumentException("Illegal Authority format: " + authority);
        }
        if (!SystemPrivilege.class.getSimpleName().equals(split[0])) {
            throw new IllegalArgumentException("Illegal Authority name in: " + authority);
        }
        SystemPrivilege systemPrivilege = SystemPrivilege.valueOf(split[1]);
        return new SystemAuthority(systemPrivilege);
    }

    @Override
    public String getAuthority() {
        return this.systemPrivilege.getClass().getSimpleName() + " " + this.systemPrivilege.name();
    }

    public String toString() {
        return this.getAuthority();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAuthority() == null ? 0 : this.getAuthority().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemAuthority other = (SystemAuthority)obj;
        return !(this.getAuthority() == null ? other.getAuthority() != null : !this.getAuthority().equals(other.getAuthority()));
    }

    @Override
    public Privilege getPrivilege() {
        return this.systemPrivilege;
    }

    public static enum SystemPrivilege implements Privilege
    {
        MANAGE_ROLES,
        MANAGE_USERS;


        public String toString() {
            switch (this) {
                case MANAGE_ROLES: {
                    return "Manage Roles";
                }
                case MANAGE_USERS: {
                    return "Manage Users";
                }
            }
            return super.toString();
        }
    }
}

