/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.directory;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserDetailsProvider;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.Properties;

@InternalApi
public class CredentialsProviderHelper {
    private static final String USER_DETAILS_PROPERTY = "security.userDetails";
    private static final String CREDENTIALS_PROVIDER_PROPERTY = "security.credentials-provider";

    public static CredentialsProvider fromClassName(String className, Properties properties) throws Exception {
        DefaultCredentialsProvider instance;
        if (StringUtils.hasLength(className)) {
            Class<?> clazz = Class.forName(className);
            instance = clazz.newInstance();
        } else {
            instance = new DefaultCredentialsProvider();
        }
        if (instance instanceof CredentialsProvider) {
            CredentialsProvider result = instance;
            result.initialize(properties);
            return instance;
        }
        if (instance instanceof UserDetailsProvider) {
            UserDetailsProvider userDetailsProvider = (UserDetailsProvider)((Object)instance);
            UserDetails userDetails = userDetailsProvider.create(properties);
            return new DefaultCredentialsProvider(userDetails);
        }
        throw new IllegalStateException("Class '" + className + "' is not a valid credentials provider implementation.");
    }

    public static Properties createLoginProperties(String username, String password) {
        Properties properties = new Properties();
        properties.setProperty("username", username);
        properties.setProperty("password", password);
        return properties;
    }

    public static void clearCredentialsProperties(Properties properties) {
        properties.remove(USER_DETAILS_PROPERTY);
        properties.remove(CREDENTIALS_PROVIDER_PROPERTY);
    }

    public static void appendCredentials(Properties properties, CredentialsProvider credentialsProvider) {
        properties.put(CREDENTIALS_PROVIDER_PROPERTY, credentialsProvider);
    }

    public static CredentialsProvider extractCredentials(Properties properties) {
        CredentialsProvider credentials = (CredentialsProvider)CredentialsProviderHelper.extract(properties, CREDENTIALS_PROVIDER_PROPERTY, true);
        if (credentials != null) {
            return credentials;
        }
        UserDetails userDetails = (UserDetails)CredentialsProviderHelper.extract(properties, USER_DETAILS_PROPERTY, true);
        if (userDetails != null) {
            return new DefaultCredentialsProvider(userDetails);
        }
        return null;
    }

    public static void appendMarshalledCredentials(Properties properties, UserDetails userDetails, CredentialsProvider credentialsProvider) throws IOException {
        if (credentialsProvider != null) {
            properties.put(CREDENTIALS_PROVIDER_PROPERTY, new MarshalledObject<CredentialsProvider>(credentialsProvider));
        }
        if (userDetails != null) {
            properties.put(USER_DETAILS_PROPERTY, new MarshalledObject<UserDetails>(userDetails));
        }
    }

    public static CredentialsProvider extractMarshalledCredentials(Properties properties, boolean remove) {
        try {
            MarshalledObject credentials = (MarshalledObject)CredentialsProviderHelper.extract(properties, CREDENTIALS_PROVIDER_PROPERTY, remove);
            if (credentials != null) {
                return (CredentialsProvider)credentials.get();
            }
            MarshalledObject userDetails = (MarshalledObject)CredentialsProviderHelper.extract(properties, USER_DETAILS_PROPERTY, remove);
            if (userDetails != null) {
                return new DefaultCredentialsProvider((UserDetails)userDetails.get());
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new SecurityException("Failed to extract credentials", e);
        }
        catch (IOException e) {
            throw new SecurityException("Failed to extract credentials", e);
        }
    }

    private static <T> T extract(Properties properties, String key, boolean remove) {
        Object result = remove ? properties.remove(key) : properties.get(key);
        return (T)result;
    }
}

