/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.directory;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public class DefaultCredentialsProvider
extends CredentialsProvider {
    private static final long serialVersionUID = 1L;
    private UserDetails credentials;

    public DefaultCredentialsProvider() {
    }

    public DefaultCredentialsProvider(UserDetails credentials) {
        this.credentials = credentials;
    }

    public DefaultCredentialsProvider(String username, String password) {
        this(DefaultCredentialsProvider.create(username, password));
    }

    @Override
    public void initialize(Properties properties) {
        super.initialize(properties);
        String username = DefaultCredentialsProvider.getProperty(properties, "username");
        String password = DefaultCredentialsProvider.getProperty(properties, "password");
        this.credentials = DefaultCredentialsProvider.create(username, password);
    }

    @Override
    public UserDetails getUserDetails() {
        return this.credentials;
    }

    private static String getProperty(Properties properties, String key) {
        if (!properties.containsKey(key)) {
            throw new IllegalArgumentException("Property '" + key + "' is not defined");
        }
        String value = properties.getProperty(key);
        if (!StringUtils.hasLength(value)) {
            throw new IllegalArgumentException("Property '" + key + "' is null or empty");
        }
        return value;
    }

    private static UserDetails create(String username, String password) {
        return new User(username, password);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.credentials);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.credentials = (UserDetails)in.readObject();
    }
}

