/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.directory;

import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DirectoryManagerUtils {
    public static List<UserDetails> getUsersWithRole(UserManager userManager, String role) {
        Map<String, UserDetails> map = userManager.mapUsers();
        ArrayList<UserDetails> usersWithRole = new ArrayList<UserDetails>(map.size());
        block0: for (UserDetails user : map.values()) {
            Authority[] authorities;
            for (Authority authority : authorities = user.getAuthorities()) {
                if (!(authority instanceof RoleAuthority) || !((RoleAuthority)authority).getRole().equals(role)) continue;
                usersWithRole.add(user);
                continue block0;
            }
        }
        return usersWithRole;
    }

    public static List<String> getUserRoles(UserManager userManager, String username) {
        Map<String, UserDetails> map = userManager.mapUsers();
        ArrayList<String> userRoles = new ArrayList<String>();
        for (UserDetails user : map.values()) {
            Authority[] authorities;
            if (!user.getUsername().equals(username)) continue;
            for (Authority authority : authorities = user.getAuthorities()) {
                if (!(authority instanceof RoleAuthority)) continue;
                String role = ((RoleAuthority)authority).getRole();
                userRoles.add(role);
            }
        }
        return userRoles;
    }

    public static List<String> getUserRoles(UserDetails user) {
        Authority[] authorities;
        ArrayList<String> userRoles = new ArrayList<String>();
        for (Authority authority : authorities = user.getAuthorities()) {
            if (!(authority instanceof RoleAuthority)) continue;
            String role = ((RoleAuthority)authority).getRole();
            userRoles.add(role);
        }
        return userRoles;
    }
}

