/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.directory;

import com.gigaspaces.security.Authority;
import com.gigaspaces.security.AuthorityFactory;
import com.gigaspaces.security.directory.UserDetails;
import java.util.Arrays;

public class User
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private final String username;
    private String password;
    private final Authority[] authorities;

    public User(String username, String password) {
        this.username = username;
        this.password = password;
        this.authorities = new Authority[0];
    }

    public User(String username, String password, Authority ... authorities) {
        this.username = username;
        this.password = password;
        this.authorities = authorities;
    }

    public User(String username, String password, String ... authorities) {
        this.username = username;
        this.password = password;
        this.authorities = new Authority[authorities.length];
        for (int i = 0; i < authorities.length; ++i) {
            this.authorities[i] = AuthorityFactory.create(authorities[i]);
        }
    }

    @Override
    public Authority[] getAuthorities() {
        return this.authorities;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String encryptedPassword) {
        this.password = encryptedPassword;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.authorities);
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (!Arrays.equals(this.authorities, other.authorities)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

