/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.encoding;

import com.gigaspaces.security.encoding.EncodingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyFactory {
    private static final Logger logger = Logger.getLogger(KeyFactory.class.getPackage().getName());

    public static SecretKey generateKey(String algorithm) throws EncodingException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(algorithm);
            kgen.init(128);
            SecretKey key = kgen.generateKey();
            return key;
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    public static SecretKey generateKey(String key, String algorithm) throws EncodingException {
        try {
            SecretKeySpec skey = new SecretKeySpec(key.getBytes("UTF-8"), algorithm);
            return skey;
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    public static SecretKey generateKey(byte[] key, String algorithm) throws EncodingException {
        try {
            SecretKeySpec skey = new SecretKeySpec(key, algorithm);
            return skey;
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    public static SecretKey loadKey(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Unable to load a secret-key from a null resource");
        }
        try {
            InputStream inputStream = null;
            File file = new File(resourceName);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            } else {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
                if (inputStream == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Security key [" + resourceName + "] not located in classpath; Assuming default");
                    }
                    return null;
                }
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Security key [" + resourceName + "] located in classpath");
            }
            ObjectInputStream in = new ObjectInputStream(inputStream);
            SecretKey key = (SecretKey)in.readObject();
            return key;
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    public static void storeKey(SecretKey key, File file) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(key);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }
}

