/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.encoding.aes;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.ByteUtils;
import com.gigaspaces.security.encoding.ContentEncoder;
import com.gigaspaces.security.encoding.EncodingException;
import com.gigaspaces.security.encoding.KeyFactory;
import com.gigaspaces.security.encoding.aes.AesEncrypter;
import javax.crypto.SecretKey;

@InternalApi
public class AesContentEncoder
extends AesEncrypter
implements ContentEncoder {
    public AesContentEncoder() {
        this(AesContentEncoder.loadSecretKey());
    }

    public AesContentEncoder(SecretKey secretKey) {
        super(secretKey);
    }

    private static SecretKey loadSecretKey() {
        String PRIVATE_KEY_FILENAME = "gs-private.key";
        SecretKey secretKey = KeyFactory.loadKey("gs-private.key");
        if (secretKey == null) {
            secretKey = KeyFactory.generateKey(new byte[]{-83, -117, -82, -28, 100, -16, 18, 18, -105, -124, -22, 86, 102, -34, 107, 123}, "AES");
        }
        return secretKey;
    }

    @Override
    public Object decode(byte[] bytes) throws EncodingException {
        try {
            byte[] decrypted = this.dcipher.doFinal(bytes);
            Object obj = ByteUtils.bytesToObject(decrypted);
            return obj;
        }
        catch (Exception e) {
            throw new EncodingException("Failed to decode byte array.", e);
        }
    }

    @Override
    public byte[] encode(Object obj) throws EncodingException {
        try {
            byte[] objectToBytes = ByteUtils.objectToBytes(obj);
            byte[] encrypted = this.ecipher.doFinal(objectToBytes);
            return encrypted;
        }
        catch (Exception e) {
            throw new EncodingException("Failed to encode object.", e);
        }
    }
}

