/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.encoding.md5;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.security.encoding.EncodingException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@InternalApi
public class Md5Encrypter {
    private static final String algorithm = "MD5";
    private final MessageDigest messageDigest = this.getMessageDigest();

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncodingException("No such algorithm [MD5]", e);
        }
    }

    public String encrypt(String raw) {
        try {
            MessageDigest localMessageDigest = this.cloneMessageDigest();
            byte[] digest = localMessageDigest.digest(raw.getBytes("UTF-8"));
            return new String(Hex.encodeHex(digest));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("UTF-8 not supported!", e);
        }
    }

    private MessageDigest cloneMessageDigest() {
        try {
            return (MessageDigest)this.messageDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getMessageDigest();
        }
    }

    private static final class Hex {
        private Hex() {
        }

        public static String encodeHex(byte[] data) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < data.length; ++i) {
                int halfbyte = data[i] >>> 4 & 0xF;
                int two_halfs = 0;
                do {
                    if (0 <= halfbyte && halfbyte <= 9) {
                        buf.append((char)(48 + halfbyte));
                    } else {
                        buf.append((char)(97 + (halfbyte - 10)));
                    }
                    halfbyte = data[i] & 0xF;
                } while (two_halfs++ < 1);
            }
            return buf.toString();
        }
    }
}

