/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.service;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.audit.SecurityAudit;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SecurityAuditFactory {
    private static final Logger logger = Logger.getLogger(SecurityAuditFactory.class.getName());
    public static final String SECURITY_AUDIT_CLASS_PROPERTY_KEY = "com.gs.security.security-audit.class";
    private static final String DEFAULT_SECURITY_AUDIT_CLASS_REFERENCE_IMPL = "com.gigaspaces.security.audit.LoggerSecurityAudit";

    public static SecurityAudit createSecurityAudit(Properties securityProperties) throws SecurityException {
        String property;
        if (logger.isLoggable(Level.CONFIG) && (property = securityProperties.getProperty(SECURITY_AUDIT_CLASS_PROPERTY_KEY)) != null) {
            logger.config("Security security-audit class: " + property);
        }
        String securityAuditClassName = securityProperties.getProperty(SECURITY_AUDIT_CLASS_PROPERTY_KEY, DEFAULT_SECURITY_AUDIT_CLASS_REFERENCE_IMPL);
        boolean isDefault = securityAuditClassName.equals(DEFAULT_SECURITY_AUDIT_CLASS_REFERENCE_IMPL);
        try {
            Class<SecurityAudit> securityAuditClass = Thread.currentThread().getContextClassLoader().loadClass(securityAuditClassName).asSubclass(SecurityAudit.class);
            return securityAuditClass.newInstance();
        }
        catch (Exception e) {
            logger.log(isDefault ? Level.FINE : Level.SEVERE, "Failed to create an instance of SecurityAudit class", e);
            if (!isDefault) {
                throw new SecurityException("Failed to create Security Audit", e);
            }
            return null;
        }
    }
}

