/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.service;

import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationToken;
import com.gigaspaces.security.audit.AuditDetails;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.encoding.EncodingException;
import com.gigaspaces.security.encoding.KeyFactory;
import com.gigaspaces.security.encoding.aes.AesContentEncoder;
import com.gigaspaces.security.session.SessionDetails;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.crypto.SecretKey;

public class SecurityContext
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private UserDetails userDetails;
    private AuthenticationToken authenticationToken;
    private AuditDetails auditDetails;
    private transient Authentication authentication;
    private static final SecretKey secretKey = SecurityContext.generateKey();

    private static SecretKey generateKey() {
        SecretKey secretKey = KeyFactory.loadKey("gs-keystore.key");
        if (secretKey == null) {
            secretKey = KeyFactory.generateKey(new byte[]{-69, -26, 70, -58, 49, 81, 104, -9, -105, 93, -114, 26, 75, -60, 96, -39}, "AES");
        }
        return secretKey;
    }

    public SecurityContext() {
    }

    public SecurityContext(CredentialsProvider credentialsProvider) {
        this.userDetails = credentialsProvider.getUserDetails();
        this.auditDetails = new AuditDetails();
    }

    public SecurityContext(SecurityContext securityContext) {
        this.authenticationToken = securityContext.getAuthenticationToken();
        this.auditDetails = securityContext.getAuditDetails();
    }

    public SecurityContext(UserDetails userDetails, AuthenticationToken authenticationToken) {
        this.userDetails = userDetails;
        this.authenticationToken = authenticationToken;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    void applySessionDetails(SessionDetails sessionDetails) {
        this.userDetails = sessionDetails.getAuthentication().getUserDetails();
        this.authentication = sessionDetails.getAuthentication();
        this.auditDetails = sessionDetails.getAuditDetails();
    }

    public Authentication getAuthentication() {
        if (this.authentication == null) {
            this.authentication = new Authentication(this.userDetails);
        }
        return this.authentication;
    }

    public AuthenticationToken getAuthenticationToken() {
        return this.authenticationToken;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if ((flags & 1) != 0) {
            this.authenticationToken = new AuthenticationToken();
            this.authenticationToken.readExternal(in);
        }
        if ((flags & 2) != 0) {
            int length = in.readInt();
            byte[] encrypted = new byte[length];
            in.readFully(encrypted);
            AesContentEncoder contentEncoder = new AesContentEncoder(secretKey);
            try {
                this.userDetails = (UserDetails)contentEncoder.decode(encrypted);
            }
            catch (EncodingException e) {
                throw new SecurityException("Failed to decode user details; check that both client and server are using the same keystore file.", e);
            }
            if ((flags & 4) != 0) {
                this.auditDetails = new AuditDetails();
                this.auditDetails.readExternal(in);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if (this.authenticationToken != null) {
            this.authenticationToken.writeExternal(out);
        }
        if (this.userDetails != null) {
            AesContentEncoder contentEncoder = new AesContentEncoder(secretKey);
            byte[] encoded = contentEncoder.encode(this.userDetails);
            out.writeInt(encoded.length);
            out.write(encoded);
            if (this.auditDetails != null) {
                this.auditDetails.writeExternal(out);
            }
        }
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this.authenticationToken != null) {
            flags = (byte)(flags | 1);
        }
        if (this.userDetails != null) {
            flags = (byte)(flags | 2);
        }
        if (this.auditDetails != null) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    private static interface BitMap {
        public static final int AUTHENTICATION_TOKEN = 1;
        public static final int USER_DETAILS = 2;
        public static final int AUDIT_DETAILS = 4;
    }
}

