/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.service;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.internal.io.MarshObjectConvertor;
import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.AuthenticationToken;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.SecurityFactory;
import com.gigaspaces.security.SecurityManager;
import com.gigaspaces.security.audit.SecurityAudit;
import com.gigaspaces.security.authorities.GrantedAuthorities;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.service.SecurityAuditFactory;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityContextAccessor;
import com.gigaspaces.security.service.SecurityTrustInterceptor;
import com.gigaspaces.security.session.SessionDetails;
import com.gigaspaces.security.session.SessionId;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SecurityInterceptor {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.security");
    private final SecurityManager securityManager;
    private final SecurityAudit securityAudit;
    private final ConcurrentHashMap<MarshObject, AuthenticationToken> marshedCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<AuthenticationToken, SessionDetails> cache = new ConcurrentHashMap();
    private final SecurityTrustInterceptor trustInterceptor = new SecurityTrustInterceptor();
    private final AuthenticationToken trustedToken = new AuthenticationToken(SessionId.generateIdentifier());
    private final UserDetails trustedUser = new TrustedUser(String.valueOf(UUID.randomUUID()));
    private final CredentialsProvider trustedCredentialsProvider = new DefaultCredentialsProvider(this.trustedUser);

    public SecurityInterceptor(String component) {
        this(component, new Properties(), false);
    }

    public SecurityInterceptor(String component, Properties props, boolean useMinusDLast) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Security enabled for " + component);
        }
        SecurityManager injectedSecurityManager = null;
        if (props.get("com.gs.security.security-manager.class") instanceof SecurityManager) {
            injectedSecurityManager = (SecurityManager)props.remove("com.gs.security.security-manager.class");
        }
        if (injectedSecurityManager != null) {
            this.securityAudit = SecurityAuditFactory.createSecurityAudit(props);
            this.securityManager = injectedSecurityManager;
        } else {
            Properties securityProperties = SecurityFactory.loadComponentSecurityProperties(component, useMinusDLast);
            securityProperties.putAll((Map<?, ?>)props);
            this.securityAudit = SecurityAuditFactory.createSecurityAudit(securityProperties);
            this.securityManager = SecurityFactory.createSecurityManager(securityProperties);
        }
    }

    public SecurityContext authenticate(SecurityContext securityContext) {
        if (securityContext == null) {
            throw new SecurityException("Invalid security context");
        }
        UserDetails userDetails = securityContext.getUserDetails();
        if (userDetails == null) {
            throw new AuthenticationException("No authentication details were supplied");
        }
        if (this.isTrusted(userDetails)) {
            return this.createTrustedContext();
        }
        try {
            Authentication authentication = this.securityManager.authenticate(userDetails);
            MarshObjectConvertor marshObjectConvertor = new MarshObjectConvertor();
            MarshObject marshObject = marshObjectConvertor.getMarshObject(userDetails);
            AuthenticationToken authenticationToken = new AuthenticationToken(SessionId.generateIdentifier());
            AuthenticationToken cachedAuthenticationToken = this.marshedCache.putIfAbsent(marshObject, authenticationToken);
            if (cachedAuthenticationToken != null) {
                authenticationToken = cachedAuthenticationToken;
            }
            SessionDetails sessionDetails = new SessionDetails(authentication, securityContext);
            this.cache.put(authenticationToken, sessionDetails);
            SecurityContext context = new SecurityContext(authentication.getUserDetails(), authenticationToken);
            if (this.securityAudit != null) {
                this.securityAudit.authenticationSuccessful(securityContext, context);
            }
            return context;
        }
        catch (AuthenticationException authenticationException) {
            if (this.securityAudit != null) {
                this.securityAudit.authenticationFailed(securityContext, authenticationException);
            }
            throw authenticationException;
        }
        catch (IOException e) {
            throw new AuthenticationException("Could not marshal user details", e);
        }
    }

    private SecurityContext createTrustedContext() {
        return new SecurityContext(null, this.trustedToken);
    }

    public boolean isTrusted(UserDetails userDetails) {
        return this.trustedUser.equals(userDetails);
    }

    public void trustProxy(IJSpace proxy) throws RemoteException {
        ((ISpaceProxy)proxy).login(this.trustedCredentialsProvider);
    }

    public void intercept(SecurityContext securityContext, Privilege privilege, String className) {
        if (securityContext == null) {
            throw new SecurityException("Invalid security context");
        }
        AuthenticationToken token = securityContext.getAuthenticationToken();
        if (token == null) {
            throw new AuthenticationException("Authentication token is invalid");
        }
        if (this.trustInterceptor.verifyTrust(securityContext)) {
            return;
        }
        SessionDetails sessionDetails = this.cache.get(token);
        if (sessionDetails == null) {
            if (token.equals(this.trustedToken)) {
                return;
            }
            if (this.securityAudit != null) {
                this.securityAudit.authenticationInvalid(token);
            }
            throw new AuthenticationException("Authentication session is invalid");
        }
        Authentication authentication = sessionDetails.getAuthentication();
        GrantedAuthorities grantedAuthorities = authentication.getGrantedAuthorities();
        boolean granted = grantedAuthorities.isGranted(privilege, className);
        if (!granted) {
            AccessDeniedException accessDeniedException = new AccessDeniedException("User [" + authentication.getUserDetails().getUsername() + "] lacks [" + privilege + "] privileges" + (className == null ? "" : " for class [" + className + "]"));
            if (this.securityAudit != null) {
                this.securityAudit.accessDenied(securityContext, sessionDetails, privilege, className);
            }
            throw accessDeniedException;
        }
        if (this.securityAudit != null) {
            this.securityAudit.accessGranted(securityContext, sessionDetails, privilege, className);
        }
        SecurityContextAccessor.fillSecurityContext(securityContext, sessionDetails);
    }

    public UserDetails getUserDetails(AuthenticationToken authenticationToken) {
        SessionDetails sessionDetails = this.cache.get(authenticationToken);
        if (sessionDetails == null) {
            throw new AuthenticationException("Authentication token is invalid");
        }
        return sessionDetails.getAuthentication().getUserDetails();
    }

    public SpaceContext trustContext(SpaceContext spaceContext) {
        SecurityContext trustedContext = this.trustInterceptor.trust(SpaceContextHelper.getSecurityContext(spaceContext));
        return spaceContext.createCopy(trustedContext);
    }

    public boolean shouldBypassFilter(SecurityContext securityContext) {
        return this.isTrusted(securityContext.getUserDetails()) || this.trustInterceptor.verifyTrust(securityContext);
    }

    private static final class TrustedUser
    extends User {
        private static final long serialVersionUID = 1L;

        public TrustedUser(String uid) {
            super(uid, uid);
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }
}

