/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.service;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.PropertiesUtils;
import com.j_spaces.core.client.SpaceURL;

@InternalApi
public class SecurityResolver {
    private static final boolean SECURITY_ENABLED = Boolean.getBoolean("com.gs.security.enabled");

    public static boolean isSecurityEnabled() {
        return SECURITY_ENABLED;
    }

    public static boolean isSecurityEnabled(SpaceURL spaceURL) {
        boolean useLocalCache = PropertiesUtils.getBoolean(spaceURL, "useLocalCache", false);
        if (useLocalCache) {
            return false;
        }
        if (SecurityResolver.hasSecuredProperty(spaceURL)) {
            return true;
        }
        return SECURITY_ENABLED && !Boolean.getBoolean("com.gigaspaces.gsc.running");
    }

    private static boolean hasSecuredProperty(SpaceURL spaceURL) {
        return PropertiesUtils.getBoolean(spaceURL, "secured", false) || PropertiesUtils.getBoolean(spaceURL.getCustomProperties(), "secured", false);
    }
}

