/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class BinaryObject
implements Externalizable {
    private static final long serialVersionUID = -7441531324541073950L;
    private byte formatCode;
    private byte[] data;
    private transient Integer hashCode;

    public BinaryObject() {
    }

    public BinaryObject(byte formatCode, byte[] data) {
        this.formatCode = formatCode;
        this.data = data;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = Arrays.hashCode(this.data);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryObject)) {
            return false;
        }
        BinaryObject other = (BinaryObject)obj;
        if (this.formatCode != other.formatCode) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public byte getFormatCode() {
        return this.formatCode;
    }

    public void setFormatCode(byte value) {
        this.formatCode = value;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] value) {
        this.data = value;
        this.hashCode = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.formatCode = in.readByte();
        int length = in.readInt();
        this.data = new byte[length];
        in.readFully(this.data, 0, length);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.formatCode);
        out.writeInt(this.data.length);
        out.write(this.data);
    }
}

