/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs;

import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.client.spaceproxy.metadata.TypeDescFactory;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.FifoHelper;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.SpaceIdType;
import com.gigaspaces.internal.metadata.SpaceIndexTypeHelper;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.internal.transport.PbsProjectionTemplate;
import com.gigaspaces.internal.transport.PbsTemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexFactory;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.metadata.index.SpacePropertyIndex;
import com.gigaspaces.serialization.BinaryObject;
import com.gigaspaces.serialization.pbs.DotnetGenericArrayList;
import com.gigaspaces.serialization.pbs.DotnetGenericHashMap;
import com.gigaspaces.serialization.pbs.DotnetGenericLinkedHashMap;
import com.gigaspaces.serialization.pbs.DotnetGenericTreeMap;
import com.gigaspaces.serialization.pbs.IDoubleGenericType;
import com.gigaspaces.serialization.pbs.ISingleGenericType;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsPreparedTemplateCache;
import com.gigaspaces.serialization.pbs.PbsTypeInfo;
import com.gigaspaces.serialization.pbs.collections.PbsCustomTypeList;
import com.gigaspaces.serialization.pbs.collections.PbsCustomTypeMap;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class PbsEntryFormatter {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.common");
    private static final short StreamVersion = 1;
    public static final int BITMAP_TRANSIENT = 1;
    private static final int BITMAP_UID_AUTOGENERATE = 2;
    public static final int BITMAP_FIFO = 4;
    public static final int BITMAP_REPLICATE = 8;
    public static final int BITMAP_METADATA = 16;
    private static final int BITMAP_SUPPORTS_OPTIMISTIC_LOCKING = 32;
    private static final int BITMAP_SUPPORTS_DYNAMIC_PROPERTIES = 64;
    private static final byte INDEX_PROPERTY = 0;
    private static final byte INDEX_PATH = 1;
    private static final byte COMPOUND_INDEX = 2;
    private static final byte NULL_TEMPLATE = 0;
    private static final byte PREPARED_TEMPLATE_WITHOUT_METADATA = 3;
    private static final byte OBJECT_TEMPLATE = 4;
    private static final byte SQLQUERY_TEMPLATE_PARAMETERS = 5;
    private static final byte IDQUERY_TEMPLATE = 6;

    public static void writeExternalEntry(PbsOutputStream output, IGSEntry entry) {
        PbsEntryFormatter.writeEntry(output, entry.getFieldsValues(), entry.getClassName(), entry.getUID(), entry.getVersion(), entry.isTransient(), entry.isFifo(), entry.isReplicatable());
    }

    public static void writeEntry(PbsOutputStream output, Object[] values, String className, String uid, int version, boolean isTransient, boolean isFifo, boolean isReplicatable) {
        output.writeShort((short)1);
        output.writeString(className);
        if (uid != null) {
            output.writeString(uid);
        } else {
            output.writeString("");
        }
        output.writeInt(version);
        int specialFlags = 2;
        if (isTransient) {
            specialFlags |= 1;
        }
        if (isFifo) {
            specialFlags |= 4;
        }
        if (isReplicatable) {
            specialFlags |= 8;
        }
        output.writeInt(specialFlags);
        output.writeByte((byte)127);
        if (values != null) {
            output.writeInt(values.length);
            for (int i = 0; i < values.length; ++i) {
                PbsEntryFormatter.writeFieldValue(output, values[i]);
            }
        } else {
            output.writeInt(0);
        }
    }

    public static ITypeDesc readTypeDescriptor(PbsInputStream input) {
        String typeName = input.readString();
        EntryType entryType = PbsEntryFormatter.readEntryType(input);
        String[] superTypesNames = input.readStringArray();
        PropertyInfo[] propertiesInfo = PbsEntryFormatter.readTypeProperties(input);
        boolean supportsDynamicProperties = input.readBoolean();
        byte dynamicPropertiesStorageType = input.readByte();
        String documentWrapperType = input.readString();
        String idPropertyName = input.readString();
        boolean idAutoGenerate = input.readBoolean();
        String routingPropertyName = input.readString();
        Map<String, SpaceIndex> indexes = PbsEntryFormatter.readIndexes(input, idPropertyName, idAutoGenerate);
        FifoSupport fifoMode = FifoHelper.fromCode(input.readByte());
        boolean replicable = input.readBoolean();
        boolean supportsOptimisticLocking = input.readBoolean();
        String fifoGroupingPropertyPath = input.readString();
        Set<String> fifoGroupingIndexPaths = PbsEntryFormatter.readFifoGroupingIndexPaths(input);
        ITypeDesc typeDesc = TypeDescFactory.createPbsExplicitTypeDesc(entryType, typeName, superTypesNames, propertiesInfo, indexes, idPropertyName, idAutoGenerate, routingPropertyName, fifoGroupingPropertyPath, fifoGroupingIndexPaths, fifoMode, replicable, supportsOptimisticLocking, supportsDynamicProperties, dynamicPropertiesStorageType, documentWrapperType, true);
        return typeDesc;
    }

    private static Set<String> readFifoGroupingIndexPaths(PbsInputStream input) {
        int numOfGigoGroupingIndexes = input.readInt();
        if (numOfGigoGroupingIndexes < 0) {
            return null;
        }
        HashSet<String> fifoGroupingIndexPaths = new HashSet<String>();
        for (int i = 0; i < numOfGigoGroupingIndexes; ++i) {
            fifoGroupingIndexPaths.add(input.readString());
        }
        return fifoGroupingIndexPaths;
    }

    private static PropertyInfo[] readTypeProperties(PbsInputStream input) {
        int length = input.readInt();
        PropertyInfo[] properties = new PropertyInfo[length];
        for (int i = 0; i < properties.length; ++i) {
            String name = input.readString();
            String typeName = input.readString();
            byte dotNetStorageType = input.readByte();
            properties[i] = new PropertyInfo(name, typeName, null, SpaceDocumentSupport.DEFAULT, StorageType.OBJECT, dotNetStorageType);
        }
        return properties;
    }

    private static Map<String, SpaceIndex> readIndexes(PbsInputStream input, String idPropertyName, boolean idAutoGenerate) {
        int length = input.readInt();
        if (length == -1) {
            return null;
        }
        HashMap<String, SpaceIndex> indexes = new HashMap<String, SpaceIndex>();
        for (int i = 0; i < length; ++i) {
            SpaceIndex index;
            String indexPath = input.readString();
            SpaceIndexType indexType = SpaceIndexTypeHelper.fromCode(input.readByte());
            boolean unique = input.readBoolean();
            byte indexPathType = input.readByte();
            switch (indexPathType) {
                case 0: {
                    int propertyPos = input.readInt();
                    index = new SpacePropertyIndex(indexPath, indexType, unique, propertyPos);
                    break;
                }
                case 1: {
                    index = SpaceIndexFactory.createPathIndex(indexPath, indexType);
                    break;
                }
                case 2: {
                    String[] paths = input.readStringArray();
                    index = SpaceIndexFactory.createCompoundIndex(paths);
                    break;
                }
                default: {
                    throw new PBSInternalSpaceException("Unexpected index path type byte [" + indexPathType + "]");
                }
            }
            indexes.put(indexPath, index);
        }
        return indexes;
    }

    public static ITypeDesc readTypeDescIfExists(PbsInputStream input, String typeName, EntryType entryType) {
        int flags = input.readInt();
        boolean hasTypeDesc = (flags & 0x10) != 0;
        return hasTypeDesc ? PbsEntryFormatter.readTypeDesc(input, typeName, entryType, flags) : null;
    }

    public static ITypeDesc readTypeDesc(PbsInputStream input, String typeName, EntryType entryType, int flags) {
        boolean isFifo = (flags & 4) != 0;
        boolean isReplicable = (flags & 8) != 0;
        boolean isAutoGen = (flags & 2) != 0;
        boolean supportsOptimisticLocking = (flags & 0x20) != 0;
        boolean supportsDynamicProperties = (flags & 0x40) != 0;
        FifoSupport fifoMode = FifoHelper.fromOld(isFifo);
        String[] superClassesNames = input.readStringArray();
        int fields = input.readInt();
        String[] fieldsNames = new String[fields];
        String[] fieldsTypes = new String[fields];
        SpaceIndexType[] fieldsIndexes = new SpaceIndexType[fields];
        for (int i = 0; i < fields; ++i) {
            fieldsNames[i] = input.readString();
            fieldsTypes[i] = input.readString();
            fieldsIndexes[i] = SpaceIndexTypeHelper.fromCode(input.readByte());
        }
        String uidFieldName = input.readString();
        String routingFieldName = input.readString();
        return TypeDescFactory.createPbsTypeDesc(entryType, typeName, null, superClassesNames, fieldsNames, fieldsTypes, fieldsIndexes, uidFieldName, isAutoGen, routingFieldName, fifoMode, isReplicable, supportsOptimisticLocking, supportsDynamicProperties);
    }

    public static void writePbsEntryPacket(PbsOutputStream output, PbsEntryPacket pbsEntry) {
        byte[] array = pbsEntry.getStreamBytes();
        output.write(array, 0, array.length);
        PbsEntryFormatter.writeDynamicProperties(output, pbsEntry.getDynamicProperties());
    }

    public static void writeDynamicProperties(PbsOutputStream output, Map<String, Object> dynamicProperties) {
        if (dynamicProperties == null || dynamicProperties.isEmpty()) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(dynamicProperties.size());
        for (Map.Entry<String, Object> dynamicProperty : dynamicProperties.entrySet()) {
            output.writeRepetitiveString(dynamicProperty.getKey());
            PbsEntryFormatter.writeFieldValue(output, dynamicProperty.getValue());
        }
    }

    public static void writePbsEntryPacketLazy(PbsOutputStream output, PbsEntryPacket packet) {
        if (packet == null) {
            output.writeIntFixed(-1);
            return;
        }
        int startPosition = output.size();
        output.writeIntFixed(0);
        byte[] array = packet.getStreamBytes();
        output.write(array, 0, array.length);
        PbsEntryFormatter.writeDynamicProperties(output, packet.getDynamicProperties());
        int endPosition = output.size();
        int length = endPosition - startPosition - 4;
        output.setSize(startPosition);
        output.writeIntFixed(length);
        output.setSize(endPosition);
    }

    public static void writeNullablePbsEntryPacket(PbsOutputStream output, PbsEntryPacket pbsEntry) {
        if (pbsEntry != null) {
            output.writeBoolean(true);
            PbsEntryFormatter.writePbsEntryPacket(output, pbsEntry);
        } else {
            output.writeBoolean(false);
        }
    }

    public static void writePbsEntryPacketObjectArray(PbsOutputStream output, Object[] objects) {
        if (objects != null) {
            output.writeInt(objects.length);
            for (Object entry : objects) {
                PbsEntryFormatter.writePbsEntryPacket(output, (PbsEntryPacket)entry);
            }
        } else {
            output.writeInt(-1);
        }
    }

    public static void writeNullablePbsEntryPacketObjectArray(PbsOutputStream output, Object[] objects) {
        if (objects != null) {
            output.writeInt(objects.length);
            for (Object entry : objects) {
                PbsEntryFormatter.writeNullablePbsEntryPacket(output, (PbsEntryPacket)entry);
            }
        } else {
            output.writeInt(-1);
        }
    }

    public static void writeFieldValue(PbsOutputStream output, Object value) {
        PbsTypeInfo typeInfo = PbsTypeInfo.getTypeInfo(value);
        output.writeByte(typeInfo.typeCode);
        switch (typeInfo.typeCode) {
            case 127: {
                break;
            }
            case 7: 
            case 11: {
                output.writeByte((Byte)value);
                break;
            }
            case 9: 
            case 12: {
                output.writeInt(((Short)value).intValue());
                break;
            }
            case 2: 
            case 13: {
                output.writeInt((Integer)value);
                break;
            }
            case 8: 
            case 14: {
                output.writeLong((Long)value);
                break;
            }
            case 3: 
            case 15: {
                output.writeFloat(((Float)value).floatValue());
                break;
            }
            case 4: 
            case 16: {
                output.writeDouble((Double)value);
                break;
            }
            case 6: 
            case 17: {
                output.writeBoolean((Boolean)value);
                break;
            }
            case 5: 
            case 18: {
                output.writeChar(((Character)value).charValue());
                break;
            }
            case 1: {
                output.writeString((String)value);
                break;
            }
            case 22: {
                output.writeDateTime((Date)value);
                break;
            }
            case 23: {
                output.writeDecimal((BigDecimal)value);
                break;
            }
            case 24: {
                output.writeUUID((UUID)value);
                break;
            }
            case 56: {
                output.writeByteArray((byte[])value);
                break;
            }
            case 58: {
                output.writeShortArray((short[])value);
                break;
            }
            case 51: {
                output.writeIntArray((int[])value);
                break;
            }
            case 57: {
                output.writeLongArray((long[])value);
                break;
            }
            case 52: {
                output.writeFloatArray((float[])value);
                break;
            }
            case 53: {
                output.writeDoubleArray((double[])value);
                break;
            }
            case 55: {
                output.writeBooleanArray((boolean[])value);
                break;
            }
            case 54: {
                output.writeCharArray((char[])value);
                break;
            }
            case 50: {
                output.writeStringArray((String[])value);
                break;
            }
            case 31: {
                PbsEntryFormatter.writeArray(output, value, typeInfo);
                break;
            }
            case 70: 
            case 73: 
            case 90: {
                PbsEntryFormatter.writeList(output, typeInfo, (List)value);
                break;
            }
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: 
            case 93: 
            case 94: {
                PbsEntryFormatter.writeMap(output, typeInfo, (Map)value);
                break;
            }
            case 48: {
                PbsEntryFormatter.writePbsObject(output, value);
                break;
            }
            case 88: {
                PbsEntryFormatter.writeDocumentObject(output, (SpaceDocument)value);
                break;
            }
            case 49: {
                output.writeBinaryObject((BinaryObject)value);
                break;
            }
            case 87: {
                PbsEntryFormatter.writeDocumentProperties(output, (DocumentProperties)value);
                break;
            }
            default: {
                throw new PBSInternalSpaceException("PBS failed on write due to unsupported type code: " + typeInfo.typeCode);
            }
        }
    }

    private static void writeDocumentProperties(PbsOutputStream output, DocumentProperties value) {
        output.writeInt(value.size());
        for (Map.Entry<String, Object> documentProperty : value.entrySet()) {
            output.writeRepetitiveString(documentProperty.getKey());
            PbsEntryFormatter.writeFieldValue(output, documentProperty.getValue());
        }
    }

    public static Object readFieldValue(PbsInputStream input) {
        return PbsEntryFormatter.readFieldValue(input, null);
    }

    public static Object readFieldValue(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        byte code = input.readByte();
        switch (code) {
            case 127: {
                return null;
            }
            case 7: 
            case 11: {
                return input.readByte();
            }
            case 9: 
            case 12: {
                return input.readShort();
            }
            case 2: 
            case 13: {
                return input.readInt();
            }
            case 8: 
            case 14: {
                return input.readLong();
            }
            case 3: 
            case 15: {
                return Float.valueOf(input.readFloat());
            }
            case 4: 
            case 16: {
                return input.readDouble();
            }
            case 6: 
            case 17: {
                return input.readBoolean();
            }
            case 5: 
            case 18: {
                return Character.valueOf(input.readChar());
            }
            case 1: {
                return input.readString();
            }
            case 22: {
                return input.readDateTime();
            }
            case 23: {
                return input.readDecimal();
            }
            case 24: {
                return input.readUUID();
            }
            case 56: {
                return input.readByteArray();
            }
            case 58: {
                return input.readShortArray();
            }
            case 51: {
                return input.readIntArray();
            }
            case 57: {
                return input.readLongArray();
            }
            case 52: {
                return input.readFloatArray();
            }
            case 53: {
                return input.readDoubleArray();
            }
            case 55: {
                return input.readBoolArray();
            }
            case 54: {
                return input.readCharArray();
            }
            case 50: {
                return input.readStringArray();
            }
            case 31: {
                return PbsEntryFormatter.readArray(input, contextSpaceProxy);
            }
            case 70: 
            case 73: 
            case 90: {
                return PbsEntryFormatter.readList(input, code, contextSpaceProxy);
            }
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: 
            case 93: 
            case 94: {
                return PbsEntryFormatter.readMap(input, code, contextSpaceProxy);
            }
            case 48: {
                return PbsEntryFormatter.readPbsObject(input, contextSpaceProxy);
            }
            case 88: {
                return PbsEntryFormatter.readDocumentObject(input, contextSpaceProxy);
            }
            case 49: {
                return input.readBinaryObject();
            }
            case 87: {
                return PbsEntryFormatter.readDocumentProperties(input, contextSpaceProxy);
            }
        }
        throw new PBSInternalSpaceException("PBS failed on read due to unsupported type code: " + code);
    }

    private static DocumentProperties readDocumentProperties(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        int length = input.readInt();
        DocumentProperties properties = new DocumentProperties(length);
        for (int i = 0; i < length; ++i) {
            String propertyName = input.readRepetitiveString();
            Object value = PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
            properties.put(propertyName, value);
        }
        return properties;
    }

    private static void writePbsObject(PbsOutputStream output, Object value) {
        SpaceTypeInfo typeInfo = (SpaceTypeInfo)SpaceTypeInfoRepository.getGlobalRepository().getByType(value.getClass());
        int length = typeInfo.getNumOfSpaceProperties();
        Object[] values = new Object[length];
        for (int i = 0; i < length; ++i) {
            SpacePropertyInfo propertyInfo = typeInfo.getProperty(i);
            Object propertyValue = propertyInfo.getValue(value);
            values[i] = propertyInfo.convertToNullIfNeeded(propertyValue);
        }
        ExternalEntry entry = new ExternalEntry(typeInfo.getName(), values);
        PbsEntryFormatter.writeExternalEntry(output, entry);
    }

    private static Object readPbsObject(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        SpaceTypeInfo typeInfo;
        PbsEntryPacket component = new PbsEntryPacket(input, null, null);
        String typeName = component.getTypeName();
        Object[] values = component.getFieldValues();
        try {
            typeInfo = (SpaceTypeInfo)SpaceTypeInfoRepository.getGlobalRepository().getByName(typeName);
        }
        catch (SpaceMetadataException e) {
            if (contextSpaceProxy == null) {
                throw e;
            }
            try {
                contextSpaceProxy.loadRemoteClass(typeName);
            }
            catch (ClassNotFoundException cnfe) {
                throw e;
            }
            typeInfo = (SpaceTypeInfo)SpaceTypeInfoRepository.getGlobalRepository().getByName(typeName);
        }
        Object obj = typeInfo.createInstance();
        int length = typeInfo.getNumOfSpaceProperties();
        for (int i = 0; i < length; ++i) {
            SpacePropertyInfo propertyInfo = typeInfo.getProperty(i);
            propertyInfo.setValue(obj, propertyInfo.convertFromNullIfNeeded(values[i]));
        }
        return obj;
    }

    private static void writeDocumentObject(PbsOutputStream output, SpaceDocument value) {
        output.writeString(value.getTypeName());
        Map<String, Object> properties = value.getProperties();
        output.writeInt(properties.size());
        for (Map.Entry<String, Object> iterable_element : properties.entrySet()) {
            output.writeString(iterable_element.getKey());
            PbsEntryFormatter.writeFieldValue(output, iterable_element.getValue());
        }
    }

    private static SpaceDocument readDocumentObject(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        String className = input.readString();
        SpaceDocument document = new SpaceDocument(className);
        int length = input.readInt();
        for (int i = 0; i < length; ++i) {
            String propertyName = input.readString();
            Object value = PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
            document.setProperty(propertyName, value);
        }
        return document;
    }

    private static void writeArray(PbsOutputStream output, Object value, PbsTypeInfo arrayTypeInfo) {
        if (arrayTypeInfo.typeCode == 31) {
            output.writeByte(arrayTypeInfo.componentType.typeCode);
        }
        switch (arrayTypeInfo.componentType.typeCode) {
            case 11: {
                output.writeByteWrapperArray((Byte[])value);
                break;
            }
            case 12: {
                output.writeShortWrapperArray((Short[])value);
                break;
            }
            case 13: {
                output.writeIntegerWrapperArray((Integer[])value);
                break;
            }
            case 14: {
                output.writeLongWrapperArray((Long[])value);
                break;
            }
            case 15: {
                output.writeFloatWrapperArray((Float[])value);
                break;
            }
            case 16: {
                output.writeDoubleWrapperArray((Double[])value);
                break;
            }
            case 17: {
                output.writeBooleanWrapperArray((Boolean[])value);
                break;
            }
            case 18: {
                output.writeCharWrapperArray((Character[])value);
                break;
            }
            case 22: {
                output.writeDateTimeArray((Date[])value);
                break;
            }
            case 23: {
                output.writeDecimalArray((BigDecimal[])value);
                break;
            }
            case 24: {
                output.writeUUIDArray((UUID[])value);
                break;
            }
            case 87: {
                PbsEntryFormatter.writeDocumentPropertiesArray(output, (DocumentProperties[])value);
                break;
            }
            case 48: {
                PbsEntryFormatter.writePbsObjectArray(output, (Object[])value);
                break;
            }
            case 88: {
                PbsEntryFormatter.writeDocumentObjectComponentArray(output, (SpaceDocument[])value);
                break;
            }
            default: {
                throw new PBSInternalSpaceException("PBS failed on array write due to unsupported type code: " + arrayTypeInfo.componentType.typeCode);
            }
        }
    }

    private static Object readArray(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        byte componentTypeCode = input.readByte();
        switch (componentTypeCode) {
            case 11: {
                return input.readByteWrapperArray();
            }
            case 12: {
                return input.readShortWrapperArray();
            }
            case 13: {
                return input.readIntegerWrapperArray();
            }
            case 14: {
                return input.readLongWrapperArray();
            }
            case 15: {
                return input.readFloatWrapperArray();
            }
            case 16: {
                return input.readDoubleWrapperArray();
            }
            case 17: {
                return input.readBooleanWrapperArray();
            }
            case 18: {
                return input.readCharWrapperArray();
            }
            case 22: {
                return input.readDateTimeArray();
            }
            case 23: {
                return input.readDecimalArray();
            }
            case 24: {
                return input.readUUIDArray();
            }
            case 87: {
                return PbsEntryFormatter.readDocumentPropertiesArray(input, contextSpaceProxy);
            }
            case 48: {
                return PbsEntryFormatter.readPbsObjectArray(input, contextSpaceProxy);
            }
            case 88: {
                return PbsEntryFormatter.readDocumentObjectComponentArray(input, contextSpaceProxy);
            }
        }
        throw new PBSInternalSpaceException("PBS failed on array read due to unsupported type code: " + componentTypeCode);
    }

    private static void writeDocumentObjectComponentArray(PbsOutputStream output, SpaceDocument[] array) {
        String arrName = array.length == 0 ? Object.class.getName() : array[0].getTypeName();
        output.writeString(arrName);
        output.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            PbsEntryFormatter.writeFieldValue(output, array[i]);
        }
    }

    private static SpaceDocument[] readDocumentObjectComponentArray(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        String typeName = input.readString();
        int length = input.readInt();
        SpaceDocument[] retValue = new SpaceDocument[length];
        for (int i = 0; i < length; ++i) {
            retValue[i] = (SpaceDocument)PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
        }
        return retValue;
    }

    private static void writeDocumentPropertiesArray(PbsOutputStream output, DocumentProperties[] value) {
        output.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            PbsEntryFormatter.writeDocumentProperties(output, value[i]);
        }
    }

    private static DocumentProperties[] readDocumentPropertiesArray(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        int length = input.readInt();
        DocumentProperties[] result = new DocumentProperties[length];
        for (int i = 0; i < length; ++i) {
            result[i] = PbsEntryFormatter.readDocumentProperties(input, contextSpaceProxy);
        }
        return result;
    }

    private static void writePbsObjectArray(PbsOutputStream output, Object[] array) {
        String arrName = array.getClass().getComponentType().getName();
        output.writeString(arrName);
        output.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            PbsEntryFormatter.writeFieldValue(output, array[i]);
        }
    }

    private static Object readPbsObjectArray(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        Class<?> objClass;
        String className = input.readString();
        try {
            objClass = ClassLoaderHelper.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                if (contextSpaceProxy == null) {
                    throw e;
                }
                objClass = contextSpaceProxy.loadRemoteClass(className);
            }
            catch (ClassNotFoundException ei) {
                _logger.log(Level.SEVERE, "PBS error: Object array class not found [" + className + "]");
                throw new ConversionException("PBS error: Object array class not found [" + className + "].", e);
            }
        }
        int length = input.readInt();
        Object[] retValue = (Object[])Array.newInstance(objClass, length);
        for (int i = 0; i < length; ++i) {
            retValue[i] = PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
        }
        return retValue;
    }

    private static void writeList(PbsOutputStream output, PbsTypeInfo listTypeInfo, List<?> list) {
        if (listTypeInfo.typeCode == 70) {
            output.writeString(((PbsCustomTypeList)list).getTypeName());
        } else if (PbsEntryFormatter.isGeneric(listTypeInfo.typeCode)) {
            output.writeString(((ISingleGenericType)((Object)list)).getGenericType());
        }
        int length = list.size();
        output.writeInt(length);
        if (list instanceof RandomAccess) {
            for (int i = 0; i < length; ++i) {
                Object item = list.get(i);
                PbsEntryFormatter.writeFieldValue(output, item);
            }
        } else {
            for (Object item : list) {
                PbsEntryFormatter.writeFieldValue(output, item);
            }
        }
    }

    private static Object readList(PbsInputStream input, byte listTypeCode, ISpaceProxy contextSpaceProxy) {
        String customTypeName = null;
        String genericTypeName = null;
        if (listTypeCode == 70) {
            customTypeName = input.readString();
        } else if (PbsEntryFormatter.isGeneric(listTypeCode)) {
            genericTypeName = input.readString();
        }
        int length = input.readInt();
        DotnetGenericArrayList list = null;
        switch (listTypeCode) {
            case 70: {
                list = new PbsCustomTypeList(length, customTypeName);
                break;
            }
            case 73: {
                list = new ArrayList(length);
                break;
            }
            case 90: {
                list = new DotnetGenericArrayList(length, genericTypeName);
                break;
            }
            default: {
                throw new PBSInternalSpaceException("PBS failed on list read due to unsupported list type code: " + listTypeCode);
            }
        }
        for (int i = 0; i < length; ++i) {
            Object item = PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
            list.add(item);
        }
        return list;
    }

    private static void writeMap(PbsOutputStream output, PbsTypeInfo mapTypeInfo, Map map) {
        if (mapTypeInfo.typeCode == 80) {
            output.writeString(((PbsCustomTypeMap)map).getTypeName());
        } else if (PbsEntryFormatter.isGeneric(mapTypeInfo.typeCode)) {
            IDoubleGenericType genType = (IDoubleGenericType)((Object)map);
            output.writeString(genType.getFirstGenericType());
            output.writeString(genType.getSecondGenericType());
        }
        int length = map.size();
        output.writeInt(length);
        for (Map.Entry entry : map.entrySet()) {
            PbsEntryFormatter.writeFieldValue(output, entry.getKey());
            PbsEntryFormatter.writeFieldValue(output, entry.getValue());
        }
    }

    private static Object readMap(PbsInputStream input, byte mapTypeCode, ISpaceProxy contextSpaceProxy) {
        float defaultLoadFactor = 0.75f;
        String customTypeName = null;
        String keyGenericType = null;
        String valueGenericType = null;
        if (mapTypeCode == 80) {
            customTypeName = input.readString();
        } else if (PbsEntryFormatter.isGeneric(mapTypeCode)) {
            keyGenericType = input.readString();
            valueGenericType = input.readString();
        }
        int length = input.readInt();
        int capacity = (int)Math.ceil((float)length / 0.75f);
        Map<Object, Object> map = null;
        switch (mapTypeCode) {
            case 80: {
                map = new PbsCustomTypeMap(capacity, 0.75f, customTypeName);
                break;
            }
            case 83: {
                map = new HashMap(capacity, 0.75f);
                break;
            }
            case 86: {
                map = new LinkedHashMap(capacity, 0.75f);
                break;
            }
            case 85: {
                map = new Properties();
                break;
            }
            case 84: {
                map = new TreeMap();
                break;
            }
            case 92: {
                map = new DotnetGenericHashMap(capacity, 0.75f, keyGenericType, valueGenericType);
                break;
            }
            case 94: {
                map = new DotnetGenericLinkedHashMap(capacity, 0.75f, keyGenericType, valueGenericType);
                break;
            }
            case 93: {
                map = new DotnetGenericTreeMap(keyGenericType, valueGenericType);
                break;
            }
            default: {
                throw new PBSInternalSpaceException("PBS failed on map read due to unsupported map type code: " + mapTypeCode);
            }
        }
        for (int i = 0; i < length; ++i) {
            Object key = PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
            Object value = PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
            map.put(key, value);
        }
        return map;
    }

    public static void writePrimitiveArray(PbsOutputStream output, Object[] array) {
        if (array == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                PbsEntryFormatter.writeFieldValue(output, array[i]);
            }
        }
    }

    public static Object[] readPrimitiveArray(PbsInputStream input, ISpaceProxy contextSpaceProxy) {
        int length = input.readInt();
        if (length == -1) {
            return null;
        }
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = PbsEntryFormatter.readFieldValue(input, contextSpaceProxy);
        }
        return array;
    }

    private static Object createInstance(String className) {
        try {
            Class clazz = ClassLoaderHelper.loadClass(className);
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new PBSInternalSpaceException("PBS failed to load class " + className, e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new PBSInternalSpaceException("PBS failed to instantiate class " + className, e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new PBSInternalSpaceException("PBS failed to instantiate class " + className, e);
        }
    }

    public static PbsEntryPacket readPbsEntryPacket(PbsInputStream input) {
        return PbsEntryFormatter.readPbsEntryPacket(input, false);
    }

    public static PbsTemplatePacket readPbsTemplatePacket(PbsInputStream input) {
        return (PbsTemplatePacket)PbsEntryFormatter.readPbsEntryPacket(input, true);
    }

    public static PbsEntryPacket[] readPbsEntryPacketArray(PbsInputStream input) {
        int length = input.readInt();
        if (length < 0) {
            return null;
        }
        PbsEntryPacket[] entries = new PbsEntryPacket[length];
        for (int i = 0; i < length; ++i) {
            entries[i] = PbsEntryFormatter.readPbsEntryPacket(input, false);
        }
        return entries;
    }

    private static PbsEntryPacket readPbsEntryPacket(PbsInputStream input, boolean isTemplate) {
        PbsEntryPacket result;
        byte[] streamBytes = input.readFixedByteArray();
        DocumentProperties dynamicProperties = PbsEntryFormatter.readDynamicProperties(input);
        if (streamBytes == null) {
            result = PbsTemplatePacket.getNullTemplate(QueryResultTypeInternal.OBJECT_DOTNET);
        } else if (isTemplate) {
            QueryResultTypeInternal queryResultType = PbsEntryFormatter.readQueryResultType(input);
            result = new PbsTemplatePacket(streamBytes, (Map<String, Object>)dynamicProperties, queryResultType);
        } else {
            EntryType entryType = PbsEntryFormatter.readEntryType(input);
            result = new PbsEntryPacket(streamBytes, dynamicProperties, entryType);
        }
        return result;
    }

    public static DocumentProperties readDynamicProperties(PbsInputStream input) {
        boolean hasDynamicProperties = input.readBoolean();
        if (!hasDynamicProperties) {
            return null;
        }
        int length = input.readIntFixed();
        if (length == 0) {
            return null;
        }
        DocumentProperties properties = new DocumentProperties();
        for (int i = 0; i < length; ++i) {
            String key = input.readRepetitiveString();
            Object value = PbsEntryFormatter.readFieldValue(input);
            properties.put(key, value);
        }
        return properties;
    }

    public static ITemplatePacket readPbsTemplate(PbsInputStream input, ISpaceProxy spaceProxy) {
        return PbsEntryFormatter.readPbsTemplate(input, spaceProxy, null);
    }

    public static ITemplatePacket readPbsTemplate(PbsInputStream input, ISpaceProxy spaceProxy, ITypeDesc typeDescriptor) {
        byte templateTypeCode = input.readByte();
        switch (templateTypeCode) {
            case 0: {
                return PbsTemplatePacket.getNullTemplate(QueryResultTypeInternal.OBJECT_DOTNET);
            }
            case 3: {
                long templateHandleId = input.readLong();
                return PbsPreparedTemplateCache.getCache().get(templateHandleId);
            }
            case 4: {
                return PbsEntryFormatter.readPbsTemplatePacket(input);
            }
            case 5: {
                return PbsEntryFormatter.readSqlQuery(input, spaceProxy, typeDescriptor);
            }
            case 6: {
                return PbsEntryFormatter.readIdQueryTemplate(input, spaceProxy);
            }
        }
        throw new PBSInternalSpaceException("readPbsTemplate received unknown code " + templateTypeCode);
    }

    private static ITemplatePacket readIdQueryTemplate(PbsInputStream input, ISpaceProxy spaceProxy) {
        String typeName = input.readRepetitiveString();
        Object id = PbsEntryFormatter.readFieldValue(input, spaceProxy);
        Object routing = PbsEntryFormatter.readFieldValue(input, spaceProxy);
        int version = input.readInt();
        QueryResultTypeInternal queryResultType = PbsEntryFormatter.readQueryResultType(input);
        PbsProjectionTemplate projectionTemplate = PbsEntryFormatter.readProjectionTemplate(input);
        ITypeDesc typeDesc = spaceProxy.getDirectProxy().getTypeManager().getTypeDescByName(typeName);
        return TemplatePacketFactory.createIdOrUidPacket(typeDesc, queryResultType, routing, id, version, projectionTemplate);
    }

    public static ITemplatePacket readSqlQuery(PbsInputStream input, ISpaceProxy spaceProxy, ITypeDesc typeDescriptor) {
        String typeName = input.readRepetitiveString();
        QueryResultTypeInternal queryResultType = PbsEntryFormatter.readQueryResultType(input);
        ITypeDesc implicitTypeDesc = PbsEntryFormatter.readTypeDescIfExists(input, typeName, queryResultType.getEntryType());
        String expression = input.readString();
        Object[] parameters = PbsEntryFormatter.readPrimitiveArray(input, spaceProxy);
        Object routing = PbsEntryFormatter.readFieldValue(input, spaceProxy);
        PbsProjectionTemplate projectionTemplate = PbsEntryFormatter.readProjectionTemplate(input);
        SQLQuery sqlQuery = new SQLQuery(typeName, expression, parameters);
        sqlQuery.setRouting(routing);
        if (typeDescriptor == null) {
            typeDescriptor = implicitTypeDesc;
        }
        if (typeDescriptor != null) {
            spaceProxy.getDirectProxy().getTypeManager().registerTypeDesc(typeDescriptor);
        }
        return PbsEntryFormatter.getTemplatePacketFromSqlQuery(sqlQuery, spaceProxy, projectionTemplate, queryResultType);
    }

    public static PbsProjectionTemplate readProjectionTemplate(PbsInputStream input) {
        PbsProjectionTemplate projectionTemplate = null;
        if (input.readBoolean()) {
            byte[] streamBytes = input.readFixedByteArray();
            String[] dynamicProperties = input.readRepetitiveStringArray();
            String[] fixedPaths = input.readRepetitiveStringArray();
            String[] dynamicPaths = input.readRepetitiveStringArray();
            projectionTemplate = new PbsProjectionTemplate(streamBytes, dynamicProperties, fixedPaths, dynamicPaths);
        }
        return projectionTemplate;
    }

    public static ITemplatePacket getCppTemplatePacketFromSqlQuery(SQLQuery<?> sqlQuery, ISpaceProxy spaceProxy) {
        return PbsEntryFormatter.getTemplatePacketFromSqlQuery(sqlQuery, spaceProxy, null, QueryResultTypeInternal.CPP);
    }

    public static ITemplatePacket getTemplatePacketFromSqlQuery(SQLQuery<?> sqlQuery, ISpaceProxy spaceProxy, PbsProjectionTemplate projectionTemplate, QueryResultTypeInternal resultType) {
        ITemplatePacket templatePacket = spaceProxy.getDirectProxy().getTypeManager().getTemplatePacketFromObject(sqlQuery, ObjectType.SQL);
        if (!(templatePacket instanceof SQLQueryTemplatePacket)) {
            throw new IllegalStateException("Attempt to create SQLQuery and the internal conversion is not of type " + SQLQueryTemplatePacket.class.getName());
        }
        SQLQueryTemplatePacket sqlQueryTemplatePacket = (SQLQueryTemplatePacket)templatePacket;
        sqlQueryTemplatePacket.setQueryResultType(resultType);
        sqlQueryTemplatePacket.setProjectionTemplate(projectionTemplate);
        return templatePacket;
    }

    public static void writeTypeDesc(PbsOutputStream output, ITypeDesc typeDescriptor) {
        if (typeDescriptor == null) {
            output.writeBoolean(false);
            return;
        }
        output.writeBoolean(true);
        output.writeString(typeDescriptor.getTypeName());
        output.writeBoolean(typeDescriptor.isReplicable());
        output.writeByte(FifoHelper.toCode(typeDescriptor.getFifoSupport()));
        int numOfFixedProperties = typeDescriptor.getNumOfFixedProperties();
        output.writeInt(numOfFixedProperties);
        for (int i = 0; i < numOfFixedProperties; ++i) {
            PropertyInfo property = typeDescriptor.getFixedProperty(i);
            output.writeString(property.getName());
            output.writeString(property.getTypeName());
            output.writeByte(property.getDotnetStorageType());
        }
        Map<String, SpaceIndex> indexes = typeDescriptor.getIndexes();
        if (indexes == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(indexes.size());
            for (Map.Entry<String, SpaceIndex> index : indexes.entrySet()) {
                output.writeString(index.getKey());
                output.writeByte(SpaceIndexTypeHelper.toCode(index.getValue().getIndexType()));
                output.writeBoolean(index.getValue().isUnique());
            }
        }
        output.writeString(typeDescriptor.getIdPropertyName());
        output.writeBoolean(typeDescriptor.getSpaceIdType() == SpaceIdType.AUTOMATIC);
        output.writeString(typeDescriptor.getRoutingPropertyName());
        output.writeBoolean(typeDescriptor.supportsOptimisticLocking());
        output.writeBoolean(typeDescriptor.supportsDynamicProperties());
        output.writeByte(typeDescriptor.getDotnetDynamicPropertiesStorageType());
        output.writeString(typeDescriptor.getDotnetDocumentWrapperTypeName());
        output.writeStringArray(typeDescriptor.getSuperClassesNames());
        output.writeString(typeDescriptor.getFifoGroupingPropertyPath());
        PbsEntryFormatter.writeFifoGroupingIndexesPaths(output, typeDescriptor);
    }

    private static void writeFifoGroupingIndexesPaths(PbsOutputStream output, ITypeDesc typeDescriptor) {
        Set<String> fifoGroupingIndexesPaths = typeDescriptor.getFifoGroupingIndexesPaths();
        if (fifoGroupingIndexesPaths == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(fifoGroupingIndexesPaths.size());
            for (String path : fifoGroupingIndexesPaths) {
                output.writeString(path);
            }
        }
    }

    private static boolean isGeneric(int typeCode) {
        return typeCode == 90 || typeCode == 92 || typeCode == 94 || typeCode == 93;
    }

    public static QueryResultTypeInternal readQueryResultType(PbsInputStream input) {
        return QueryResultTypeInternal.fromCode(input.readByte());
    }

    public static EntryType readEntryType(PbsInputStream input) {
        return PbsEntryFormatter.readQueryResultType(input).getEntryType();
    }
}

