/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.serialization.BinaryObject;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsRepetitiveStringCache;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

@InternalApi
public class PbsInputStream
extends GSByteArrayInputStream
implements IThreadLocalResource {
    private boolean _isUsed;

    public PbsInputStream(byte[] buf) {
        super(buf);
    }

    public short readShort() {
        return (short)this.readInt();
    }

    public int readInt() {
        boolean fNeg;
        int b = this.readUnsignedByte();
        int value = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = this.readUnsignedByte();
            value |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            value ^= 0xFFFFFFFF;
        }
        return value;
    }

    public int readIntFixed() {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
    }

    public long readLong() {
        boolean fNeg;
        int b = this.readUnsignedByte();
        long l = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = this.readUnsignedByte();
            l |= (long)(b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public long readLongFixed() {
        long value = (long)this.readUnsignedByte() << 56;
        value += (long)this.readUnsignedByte() << 48;
        value += (long)this.readUnsignedByte() << 40;
        value += (long)this.readUnsignedByte() << 32;
        value += (long)this.readUnsignedByte() << 24;
        value += (long)this.readUnsignedByte() << 16;
        value += (long)this.readUnsignedByte() << 8;
        return value += (long)this.readUnsignedByte() << 0;
    }

    public float readFloat() {
        int rawValue = this.readInt();
        return Float.intBitsToFloat(rawValue);
    }

    public double readDouble() {
        long rawValue = this.readLong();
        return Double.longBitsToDouble(rawValue);
    }

    public boolean readBoolean() {
        return this._buffer[this._position++] == 1;
    }

    public char readChar() {
        return (char)this.readInt();
    }

    public String readString() {
        byte stringType = this.readByte();
        switch (stringType) {
            case -1: {
                return null;
            }
            case 0: {
                return "";
            }
            case 1: {
                int length = this.readInt();
                char[] chars = new char[length];
                int i = 0;
                while (i < length) {
                    chars[i++] = (char)this.readUnsignedByte();
                }
                return new String(chars);
            }
            case 2: {
                int length = this.readInt();
                char[] chars = new char[length];
                for (int i = 0; i < length; ++i) {
                    int secondByte = this._buffer[this._position + length] & 0xFF;
                    int firstByte = this.readUnsignedByte();
                    chars[i] = (char)(secondByte << 8 | firstByte);
                }
                this._position += length;
                return new String(chars);
            }
        }
        throw new PBSInternalSpaceException("PBS failed - unsupported string type: " + stringType);
    }

    public String readRepetitiveString() {
        long stringKey = this.readLong();
        return PbsRepetitiveStringCache.getCache().get(stringKey);
    }

    public String[] readRepetitiveStringArray() {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        String[] stringArray = new String[size];
        for (int i = 0; i < size; ++i) {
            stringArray[i] = this.readRepetitiveString();
        }
        return stringArray;
    }

    public Date readDateTime() {
        long rawValue = this.readLong();
        return new Date(rawValue);
    }

    public BigDecimal readDecimal() {
        String rawValue = this.readString();
        return new BigDecimal(rawValue);
    }

    public UUID readUUID() {
        long least = this.readLongFixed();
        long most = this.readLongFixed();
        return new UUID(most, least);
    }

    public byte[] readByteArray() {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        byte[] result = new byte[length];
        this.read(result, 0, result.length);
        return result;
    }

    public byte[] readFixedByteArray() {
        int length = this.readIntFixed();
        if (length == -1) {
            return null;
        }
        byte[] result = new byte[length];
        this.read(result, 0, result.length);
        return result;
    }

    public short[] readShortArray() {
        int length = this.readInt();
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    public int[] readIntArray() {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public long[] readLongArray() {
        int length = this.readInt();
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public float[] readFloatArray() {
        int length = this.readInt();
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    public double[] readDoubleArray() {
        int length = this.readInt();
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }

    public boolean[] readBoolArray() {
        int length = this.readInt();
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readBoolean();
        }
        return array;
    }

    public char[] readCharArray() {
        int length = this.readInt();
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readChar();
        }
        return array;
    }

    public String[] readStringArray() {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readString();
        }
        return array;
    }

    public Date[] readDateTimeArray() {
        int length = this.readInt();
        Date[] array = new Date[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readDateTime();
        }
        return array;
    }

    public BigDecimal[] readDecimalArray() {
        int length = this.readInt();
        BigDecimal[] array = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readDecimal();
        }
        return array;
    }

    public UUID[] readUUIDArray() {
        int length = this.readInt();
        UUID[] array = new UUID[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readUUID();
        }
        return array;
    }

    public Byte[] readByteWrapperArray() {
        int length = this.readInt();
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this._buffer[this._position++];
        }
        return array;
    }

    public Short[] readShortWrapperArray() {
        int length = this.readInt();
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readShort();
        }
        return array;
    }

    public Integer[] readIntegerWrapperArray() {
        int length = this.readInt();
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readInt();
        }
        return array;
    }

    public Long[] readLongWrapperArray() {
        int length = this.readInt();
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readLong();
        }
        return array;
    }

    public Float[] readFloatWrapperArray() {
        int length = this.readInt();
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = Float.valueOf(this.readFloat());
        }
        return array;
    }

    public Double[] readDoubleWrapperArray() {
        int length = this.readInt();
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readDouble();
        }
        return array;
    }

    public Boolean[] readBooleanWrapperArray() {
        int length = this.readInt();
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = this.readBoolean();
        }
        return array;
    }

    public Character[] readCharWrapperArray() {
        int length = this.readInt();
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            byte isNull;
            if ((isNull = this._buffer[this._position++]) == 127) continue;
            array[i] = Character.valueOf(this.readChar());
        }
        return array;
    }

    public Properties readProperties() {
        int length = this.readInt();
        Properties result = new Properties();
        for (int i = 0; i < length; ++i) {
            String key = this.readString();
            String value = this.readString();
            result.put(key, value);
        }
        return result;
    }

    public Map<String, String> readStringProperties() {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            String key = this.readString();
            String value = this.readString();
            result.put(key, value);
        }
        return result;
    }

    public BinaryObject readBinaryObject() {
        byte formatCode = this._buffer[this._position++];
        int length = this.readIntFixed();
        byte[] data = new byte[length];
        this.read(data, 0, length);
        return new BinaryObject(formatCode, data);
    }

    public Boolean readNullableBoolean() {
        byte value = this._buffer[this._position++];
        switch (value) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public Integer readNullableInt() {
        if (this.readBoolean()) {
            return this.readInt();
        }
        return null;
    }

    public Long readNullableLong() {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    public UUID readNullableUUID() {
        if (this.readBoolean()) {
            return this.readUUID();
        }
        return null;
    }

    @Override
    public boolean isUsed() {
        return this._isUsed;
    }

    @Override
    public void release() {
        this._isUsed = false;
    }

    @Override
    public void setAsUsed() {
        this._isUsed = true;
    }
}

