/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.serialization.BinaryObject;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

@InternalApi
public class PbsOutputStream
extends GSByteArrayOutputStream
implements IThreadLocalResource {
    protected static final int SIZE_INT = 4;
    protected static final int SIZE_LONG = 8;
    protected static final int SIZE_UUID = 16;
    private boolean _isUsed;

    public PbsOutputStream() {
    }

    public PbsOutputStream(int size) {
        super(size);
    }

    public void writeShort(short value) {
        this.writeInt(value);
    }

    public void writeInt(int value) {
        int b = 0;
        if (value < 0) {
            b = 64;
            value ^= 0xFFFFFFFF;
        }
        b = (byte)(b | (byte)(value & 0x3F));
        value >>= 6;
        while (value != 0) {
            b = (byte)(b | 0x80);
            this.ensureCapacity(1);
            this._buffer[this._count++] = b;
            b = (byte)(value & 0x7F);
            value >>= 7;
        }
        this.ensureCapacity(1);
        this._buffer[this._count++] = b;
    }

    public void writeIntFixed(int value) {
        this.ensureCapacity(4);
        this._buffer[this._count++] = (byte)(value >>> 24 & 0xFF);
        this._buffer[this._count++] = (byte)(value >>> 16 & 0xFF);
        this._buffer[this._count++] = (byte)(value >>> 8 & 0xFF);
        this._buffer[this._count++] = (byte)(value >>> 0 & 0xFF);
    }

    public void writeLong(long value) {
        int b = 0;
        if (value < 0L) {
            b = 64;
            value ^= 0xFFFFFFFFFFFFFFFFL;
        }
        b = (byte)(b | (byte)((int)value & 0x3F));
        value >>= 6;
        while (value != 0L) {
            b = (byte)(b | 0x80);
            this.ensureCapacity(1);
            this._buffer[this._count++] = b;
            b = (byte)((int)value & 0x7F);
            value >>= 7;
        }
        this.ensureCapacity(1);
        this._buffer[this._count++] = b;
    }

    public void writeLongFixed(long value) {
        this.ensureCapacity(8);
        this._buffer[this._count++] = (byte)(value >>> 56);
        this._buffer[this._count++] = (byte)(value >>> 48);
        this._buffer[this._count++] = (byte)(value >>> 40);
        this._buffer[this._count++] = (byte)(value >>> 32);
        this._buffer[this._count++] = (byte)(value >>> 24);
        this._buffer[this._count++] = (byte)(value >>> 16);
        this._buffer[this._count++] = (byte)(value >>> 8);
        this._buffer[this._count++] = (byte)(value >>> 0);
    }

    public void writeFloat(float value) {
        int rawValue = Float.floatToIntBits(value);
        this.writeInt(rawValue);
    }

    public void writeDouble(double value) {
        long rawValue = Double.doubleToLongBits(value);
        this.writeLong(rawValue);
    }

    public void writeBoolean(boolean value) {
        this.writeByte(value ? (byte)1 : 0);
    }

    public void writeChar(char value) {
        this.writeInt(value);
    }

    public void writeString(String value) {
        char currChar;
        int i;
        if (value == null) {
            this.writeByte((byte)-1);
            return;
        }
        int length = value.length();
        if (length == 0) {
            this.writeByte((byte)0);
            return;
        }
        int startingPosition = this._count;
        this.writeByte((byte)1);
        this.writeInt(length);
        int positionBeforeContent = this._count;
        boolean isUnicode = false;
        int asciiIntervalLength = 0;
        char[] chars = value.toCharArray();
        this.ensureCapacity(length);
        for (i = 0; i < length; ++i) {
            currChar = chars[i];
            if (currChar > '\u00ff') {
                isUnicode = true;
                asciiIntervalLength = i;
                this.ensureCapacity(length * 2 - i);
                break;
            }
            this._buffer[this._count++] = (byte)currChar;
        }
        if (isUnicode) {
            this._count = startingPosition;
            this.writeByte((byte)2);
            this._count = positionBeforeContent + asciiIntervalLength;
            i = asciiIntervalLength;
            while (i < length) {
                currChar = chars[i];
                this._buffer[this._count] = (byte)currChar;
                this._buffer[this._count + length] = (byte)(currChar >> 8);
                ++i;
                ++this._count;
            }
            for (i = 0; i < asciiIntervalLength; ++i) {
                this._buffer[this._count++] = 0;
            }
            this._count += length - asciiIntervalLength;
        }
    }

    public void writeRepetitiveString(String value) {
        this.writeString(value);
    }

    public void writeDateTime(Date value) {
        long rawValue = value.getTime();
        this.writeLong(rawValue);
    }

    public void writeDecimal(BigDecimal value) {
        String rawValue = value.toEngineeringString();
        this.writeString(rawValue);
    }

    public void writeUUID(UUID value) {
        this.ensureCapacity(16);
        this.writeLongFixed(value.getLeastSignificantBits());
        this.writeLongFixed(value.getMostSignificantBits());
    }

    public void writeByteArray(byte[] array) {
        if (array == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(array.length);
            this.write(array, 0, array.length);
        }
    }

    public void writeShortArray(short[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeShort(array[i]);
        }
    }

    public void writeIntArray(int[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeInt(array[i]);
        }
    }

    public void writeLongArray(long[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeLong(array[i]);
        }
    }

    public void writeFloatArray(float[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeFloat(array[i]);
        }
    }

    public void writeDoubleArray(double[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeDouble(array[i]);
        }
    }

    public void writeBooleanArray(boolean[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeBoolean(array[i]);
        }
    }

    public void writeCharArray(char[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeChar(array[i]);
        }
    }

    public void writeStringArray(String[] array) {
        if (array == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    this.writeByte((byte)127);
                    continue;
                }
                this.writeByte((byte)1);
                this.writeString(array[i]);
            }
        }
    }

    public void writeDateTimeArray(Date[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)22);
            this.writeDateTime(array[i]);
        }
    }

    public void writeDecimalArray(BigDecimal[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)23);
            this.writeDecimal(array[i]);
        }
    }

    public void writeUUIDArray(UUID[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)24);
            this.writeUUID(array[i]);
        }
    }

    public void writeByteWrapperArray(Byte[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)11);
            this.writeByte(array[i]);
        }
    }

    public void writeShortWrapperArray(Short[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)12);
            this.writeShort(array[i]);
        }
    }

    public void writeIntegerWrapperArray(Integer[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)13);
            this.writeInt(array[i]);
        }
    }

    public void writeLongWrapperArray(Long[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)14);
            this.writeLong(array[i]);
        }
    }

    public void writeFloatWrapperArray(Float[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)15);
            this.writeFloat(array[i].floatValue());
        }
    }

    public void writeDoubleWrapperArray(Double[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)16);
            this.writeDouble(array[i]);
        }
    }

    public void writeBooleanWrapperArray(Boolean[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)17);
            this.writeBoolean(array[i]);
        }
    }

    public void writeCharWrapperArray(Character[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.writeByte((byte)127);
                continue;
            }
            this.writeByte((byte)18);
            this.writeChar(array[i].charValue());
        }
    }

    public void writeProperties(Properties properties) {
        if (properties == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(properties.size());
            for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                this.writeString(prop.getKey().toString());
                this.writeString(prop.getValue().toString());
            }
        }
    }

    public void writeBinaryObject(BinaryObject value) {
        this.writeByte(value.getFormatCode());
        byte[] data = value.getData();
        this.writeIntFixed(data.length);
        this.write(data, 0, data.length);
    }

    @Override
    public boolean isUsed() {
        return this._isUsed;
    }

    @Override
    public void release() {
        this._isUsed = false;
    }

    @Override
    public void setAsUsed() {
        this._isUsed = true;
    }
}

