/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import java.lang.ref.SoftReference;

@InternalApi
public class PbsStreamResource {
    private static final int POOL_SIZE = Integer.getInteger("com.gs.dotnet.stream-pool-size", 3);
    private static final ThreadLocal<SoftReference<PbsOutputStream>[]> _outputStream = new ThreadLocal<SoftReference<PbsOutputStream>[]>(){

        @Override
        protected SoftReference<PbsOutputStream>[] initialValue() {
            SoftReference[] pool = new SoftReference[POOL_SIZE];
            for (int i = 0; i < POOL_SIZE; ++i) {
                pool[i] = new SoftReference<PbsOutputStream>(new PbsOutputStream());
            }
            return pool;
        }
    };
    private static final ThreadLocal<SoftReference<PbsInputStream>[]> _inputStream = new ThreadLocal<SoftReference<PbsInputStream>[]>(){

        @Override
        protected SoftReference<PbsInputStream>[] initialValue() {
            SoftReference[] pool = new SoftReference[POOL_SIZE];
            for (int i = 0; i < POOL_SIZE; ++i) {
                pool[i] = new SoftReference<Object>(null);
            }
            return pool;
        }
    };

    public static PbsOutputStream getOutputStream() {
        SoftReference<PbsOutputStream>[] pool = _outputStream.get();
        for (int i = 0; i < POOL_SIZE; ++i) {
            SoftReference<PbsOutputStream> softReference = pool[i];
            PbsOutputStream output = softReference.get();
            if (output == null) {
                output = new PbsOutputStream();
                pool[i] = new SoftReference<PbsOutputStream>(output);
                output.setAsUsed();
                return output;
            }
            if (output.isUsed()) continue;
            output.reset();
            output.setAsUsed();
            return output;
        }
        PbsOutputStream output = new PbsOutputStream();
        output.setAsUsed();
        return output;
    }

    public static void releasePbsStream(IThreadLocalResource pbsStream) {
        pbsStream.release();
    }

    public static PbsInputStream getInputStream(byte[] buffer) {
        SoftReference<PbsInputStream>[] pool = _inputStream.get();
        for (int i = 0; i < POOL_SIZE; ++i) {
            SoftReference<PbsInputStream> softReference = pool[i];
            PbsInputStream input = softReference.get();
            if (input == null) {
                input = new PbsInputStream(buffer);
                pool[i] = new SoftReference<PbsInputStream>(input);
                input.setAsUsed();
                return input;
            }
            if (input.isUsed()) continue;
            input.setBuffer(buffer);
            input.setAsUsed();
            return input;
        }
        PbsInputStream input = new PbsInputStream(buffer);
        input.setAsUsed();
        return input;
    }

    public static PbsInputStream getExistingInputStream() {
        SoftReference<PbsInputStream>[] pool = _inputStream.get();
        for (int i = 0; i < POOL_SIZE; ++i) {
            SoftReference<PbsInputStream> softReference = pool[i];
            PbsInputStream input = softReference.get();
            if (input == null || input.isUsed()) continue;
            input.setAsUsed();
            input.reset();
            return input;
        }
        return null;
    }
}

