/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.serialization.BinaryObject;
import com.gigaspaces.serialization.pbs.DotnetGenericArrayList;
import com.gigaspaces.serialization.pbs.DotnetGenericHashMap;
import com.gigaspaces.serialization.pbs.DotnetGenericLinkedHashMap;
import com.gigaspaces.serialization.pbs.DotnetGenericTreeMap;
import com.gigaspaces.serialization.pbs.collections.PbsCustomTypeList;
import com.gigaspaces.serialization.pbs.collections.PbsCustomTypeMap;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;

@InternalApi
public class PbsTypeInfo {
    public static final byte NULL = 127;
    public static final byte BYTE = 7;
    public static final byte SHORT = 9;
    public static final byte INTEGER = 2;
    public static final byte LONG = 8;
    public static final byte FLOAT = 3;
    public static final byte DOUBLE = 4;
    public static final byte BOOLEAN = 6;
    public static final byte CHAR = 5;
    public static final byte BYTE_WRAPPER = 11;
    public static final byte SHORT_WRAPPER = 12;
    public static final byte INTEGER_WRAPPER = 13;
    public static final byte LONG_WRAPPER = 14;
    public static final byte FLOAT_WRAPPER = 15;
    public static final byte DOUBLE_WRAPPER = 16;
    public static final byte BOOLEAN_WRAPPER = 17;
    public static final byte CHAR_WRAPPER = 18;
    public static final byte STRING = 1;
    public static final byte DATE = 22;
    public static final byte DECIMAL = 23;
    public static final byte UUID = 24;
    public static final byte ARRAY = 31;
    public static final byte OBJECT = 48;
    public static final byte BINARY = 49;
    public static final byte BYTE_ARRAY = 56;
    public static final byte SHORT_ARRAY = 58;
    public static final byte INTEGER_ARRAY = 51;
    public static final byte LONG_ARRAY = 57;
    public static final byte FLOAT_ARRAY = 52;
    public static final byte DOUBLE_ARRAY = 53;
    public static final byte BOOLEAN_ARRAY = 55;
    public static final byte CHAR_ARRAY = 54;
    public static final byte STRING_ARRAY = 50;
    public static final byte LIST_CUSTOM_TYPE = 70;
    public static final byte LIST_ARRAY = 73;
    public static final byte MAP_CUSTOM_TYPE = 80;
    public static final byte MAP_HASH = 83;
    public static final byte MAP_TREE = 84;
    public static final byte MAP_PROPERTIES = 85;
    public static final byte MAP_LINKED = 86;
    public static final byte DOCUMENT_PROPERTIES = 87;
    public static final byte DOCUMENT = 88;
    public static final byte LIST_ARRAY_GENERIC = 90;
    public static final byte MAP_HASH_GENERIC = 92;
    public static final byte MAP_TREE_GENERIC = 93;
    public static final byte MAP_LINKED_GENERIC = 94;
    public final byte typeCode;
    public final PbsTypeInfo componentType;
    private static final PbsTypeInfo NullInfo = new PbsTypeInfo(127);
    private static final PbsTypeInfo ObjectInfo = new PbsTypeInfo(48);
    private static final PbsTypeInfo DocumentInfo = new PbsTypeInfo(88);
    private static final PbsTypeInfo ObjectArrayInfo = PbsTypeInfo.PbsArray(ObjectInfo);
    private static final PbsTypeInfo BinaryInfo = new PbsTypeInfo(49);
    private static final PbsTypeInfo ByteInfo = new PbsTypeInfo(7);
    private static final PbsTypeInfo ShortInfo = new PbsTypeInfo(9);
    private static final PbsTypeInfo IntegerInfo = new PbsTypeInfo(2);
    private static final PbsTypeInfo LongInfo = new PbsTypeInfo(8);
    private static final PbsTypeInfo FloatInfo = new PbsTypeInfo(3);
    private static final PbsTypeInfo DoubleInfo = new PbsTypeInfo(4);
    private static final PbsTypeInfo BooleanInfo = new PbsTypeInfo(6);
    private static final PbsTypeInfo CharInfo = new PbsTypeInfo(5);
    private static final PbsTypeInfo ByteWrapperInfo = new PbsTypeInfo(11);
    private static final PbsTypeInfo ShortWrapperInfo = new PbsTypeInfo(12);
    private static final PbsTypeInfo IntegerWrapperInfo = new PbsTypeInfo(13);
    private static final PbsTypeInfo LongWrapperInfo = new PbsTypeInfo(14);
    private static final PbsTypeInfo FloatWrapperInfo = new PbsTypeInfo(15);
    private static final PbsTypeInfo DoubleWrapperInfo = new PbsTypeInfo(16);
    private static final PbsTypeInfo BooleanWrapperInfo = new PbsTypeInfo(17);
    private static final PbsTypeInfo CharWrapperInfo = new PbsTypeInfo(18);
    private static final PbsTypeInfo StringInfo = new PbsTypeInfo(1);
    private static final PbsTypeInfo DateInfo = new PbsTypeInfo(22);
    private static final PbsTypeInfo DecimalInfo = new PbsTypeInfo(23);
    private static final PbsTypeInfo UUIDInfo = new PbsTypeInfo(24);
    private static final PbsTypeInfo ByteArrayInfo = new PbsTypeInfo(56);
    private static final PbsTypeInfo ShortArrayInfo = new PbsTypeInfo(58);
    private static final PbsTypeInfo IntegerArrayInfo = new PbsTypeInfo(51);
    private static final PbsTypeInfo LongArrayInfo = new PbsTypeInfo(57);
    private static final PbsTypeInfo FloatArrayInfo = new PbsTypeInfo(52);
    private static final PbsTypeInfo DoubleArrayInfo = new PbsTypeInfo(53);
    private static final PbsTypeInfo BooleanArrayInfo = new PbsTypeInfo(55);
    private static final PbsTypeInfo CharArrayInfo = new PbsTypeInfo(54);
    private static final PbsTypeInfo StringArrayInfo = new PbsTypeInfo(50);
    private static final HashMap<Class<?>, PbsTypeInfo> typeInfoMap = PbsTypeInfo.loadTypeInfoMap();

    private PbsTypeInfo(byte typeCode) {
        this.typeCode = typeCode;
        this.componentType = null;
    }

    private PbsTypeInfo(byte typeCode, PbsTypeInfo componentType) {
        this.typeCode = typeCode;
        this.componentType = componentType;
    }

    private static PbsTypeInfo PbsArray(PbsTypeInfo componentType) {
        return new PbsTypeInfo(31, componentType);
    }

    private static final HashMap<Class<?>, PbsTypeInfo> loadTypeInfoMap() {
        HashMap map = new HashMap(50);
        map.put(Byte.class, ByteInfo);
        map.put(Short.class, ShortInfo);
        map.put(Integer.class, IntegerInfo);
        map.put(Long.class, LongInfo);
        map.put(Float.class, FloatInfo);
        map.put(Double.class, DoubleInfo);
        map.put(Boolean.class, BooleanInfo);
        map.put(Character.class, CharInfo);
        map.put(String.class, StringInfo);
        map.put(Date.class, DateInfo);
        map.put(BigDecimal.class, DecimalInfo);
        map.put(UUID.class, UUIDInfo);
        map.put(Object.class, ObjectInfo);
        map.put(SpaceDocument.class, DocumentInfo);
        map.put(Object[].class, ObjectArrayInfo);
        map.put(BinaryObject.class, BinaryInfo);
        map.put(byte[].class, ByteArrayInfo);
        map.put(short[].class, ShortArrayInfo);
        map.put(int[].class, IntegerArrayInfo);
        map.put(long[].class, LongArrayInfo);
        map.put(float[].class, FloatArrayInfo);
        map.put(double[].class, DoubleArrayInfo);
        map.put(boolean[].class, BooleanArrayInfo);
        map.put(char[].class, CharArrayInfo);
        map.put(String[].class, StringArrayInfo);
        map.put(Byte[].class, PbsTypeInfo.PbsArray(ByteWrapperInfo));
        map.put(Short[].class, PbsTypeInfo.PbsArray(ShortWrapperInfo));
        map.put(Integer[].class, PbsTypeInfo.PbsArray(IntegerWrapperInfo));
        map.put(Long[].class, PbsTypeInfo.PbsArray(LongWrapperInfo));
        map.put(Float[].class, PbsTypeInfo.PbsArray(FloatWrapperInfo));
        map.put(Double[].class, PbsTypeInfo.PbsArray(DoubleWrapperInfo));
        map.put(Boolean[].class, PbsTypeInfo.PbsArray(BooleanWrapperInfo));
        map.put(Character[].class, PbsTypeInfo.PbsArray(CharWrapperInfo));
        map.put(Date[].class, PbsTypeInfo.PbsArray(DateInfo));
        map.put(BigDecimal[].class, PbsTypeInfo.PbsArray(DecimalInfo));
        map.put(UUID[].class, PbsTypeInfo.PbsArray(UUIDInfo));
        map.put(SpaceDocument[].class, PbsTypeInfo.PbsArray(DocumentInfo));
        map.put(PbsCustomTypeList.class, new PbsTypeInfo(70));
        map.put(ArrayList.class, new PbsTypeInfo(73));
        map.put(DotnetGenericArrayList.class, new PbsTypeInfo(90));
        map.put(PbsCustomTypeMap.class, new PbsTypeInfo(80));
        map.put(HashMap.class, new PbsTypeInfo(83));
        map.put(LinkedHashMap.class, new PbsTypeInfo(86));
        map.put(Properties.class, new PbsTypeInfo(85));
        map.put(TreeMap.class, new PbsTypeInfo(84));
        map.put(DotnetGenericHashMap.class, new PbsTypeInfo(92));
        map.put(DotnetGenericLinkedHashMap.class, new PbsTypeInfo(94));
        map.put(DotnetGenericTreeMap.class, new PbsTypeInfo(93));
        map.put(DocumentProperties.class, new PbsTypeInfo(87));
        return map;
    }

    public static PbsTypeInfo getTypeInfo(Object value) {
        if (value == null) {
            return NullInfo;
        }
        PbsTypeInfo typeInfo = typeInfoMap.get(value.getClass());
        if (typeInfo != null) {
            return typeInfo;
        }
        if (value instanceof Object[]) {
            return ObjectArrayInfo;
        }
        return ObjectInfo;
    }

    public static PbsTypeInfo getTypeInfo(byte typeCode) {
        switch (typeCode) {
            case 127: {
                return NullInfo;
            }
            case 7: {
                return ByteInfo;
            }
            case 9: {
                return ShortInfo;
            }
            case 2: {
                return IntegerInfo;
            }
            case 8: {
                return LongInfo;
            }
            case 3: {
                return FloatInfo;
            }
            case 4: {
                return DoubleInfo;
            }
            case 6: {
                return BooleanInfo;
            }
            case 5: {
                return CharInfo;
            }
            case 1: {
                return StringInfo;
            }
            case 22: {
                return DateInfo;
            }
            case 23: {
                return DecimalInfo;
            }
            case 24: {
                return UUIDInfo;
            }
            case 49: {
                return BinaryInfo;
            }
            case 48: {
                return ObjectInfo;
            }
            case 56: {
                return ByteArrayInfo;
            }
            case 58: {
                return ShortArrayInfo;
            }
            case 51: {
                return IntegerArrayInfo;
            }
            case 57: {
                return LongArrayInfo;
            }
            case 52: {
                return FloatArrayInfo;
            }
            case 53: {
                return DoubleArrayInfo;
            }
            case 55: {
                return BooleanArrayInfo;
            }
            case 54: {
                return CharArrayInfo;
            }
            case 50: {
                return StringArrayInfo;
            }
        }
        throw new PBSInternalSpaceException("PBS failed to find type info by code: " + typeCode);
    }
}

