/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.server.blobstore;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.server.blobstore.BlobStoreStatistics;
import com.gigaspaces.server.blobstore.BlobStoreStorageStatistics;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class BlobStoreStatisticsImpl
implements BlobStoreStatistics,
Externalizable {
    private static final long serialVersionUID = 1L;
    private long cacheSize;
    private long cacheHitCount;
    private long cacheMissCount;
    private long hotDataCacheMissCount;
    private long offHeapCacheUsedBytes;
    private Collection<BlobStoreStorageStatistics> storageStatistics;
    private static final short FLAG_CACHE_SIZE = 1;
    private static final short FLAG_CACHE_HIT = 2;
    private static final short FLAG_CACHE_MISS = 4;
    private static final short FLAG_HOT_DATA_CACHE_MISS = 8;
    private static final short FLAG_OHC_USED_BYTES = 16;
    private static final short FLAG_STORAGE_STATS = 32;

    @Override
    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Override
    public long getCacheHitCount() {
        return this.cacheHitCount;
    }

    public void setCacheHitCount(long hitCount) {
        this.cacheHitCount = hitCount;
    }

    @Override
    public long getCacheMissCount() {
        return this.cacheMissCount;
    }

    public void setCacheMissCount(long missCount) {
        this.cacheMissCount = missCount;
    }

    @Override
    public long getHotDataCacheMissCount() {
        return this.hotDataCacheMissCount;
    }

    public void setHotDataCacheMissCount(long hotDataMissCount) {
        this.hotDataCacheMissCount = hotDataMissCount;
    }

    @Override
    public long getOffHeapCacheUsedBytes() {
        return this.offHeapCacheUsedBytes;
    }

    public void setOffHeapCacheUsedBytes(long offHeapCacheUsedBytes) {
        this.offHeapCacheUsedBytes = offHeapCacheUsedBytes;
    }

    @Override
    public Collection<BlobStoreStorageStatistics> getStorageStatistics() {
        return this.storageStatistics;
    }

    public void setStorageStatistics(Collection<BlobStoreStorageStatistics> storageStatistics) {
        this.storageStatistics = storageStatistics;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.buildFlags());
        if (this.cacheSize != 0L) {
            out.writeLong(this.cacheSize);
        }
        if (this.cacheHitCount != 0L) {
            out.writeLong(this.cacheHitCount);
        }
        if (this.cacheMissCount != 0L) {
            out.writeLong(this.cacheMissCount);
        }
        if (this.hotDataCacheMissCount != 0L) {
            out.writeLong(this.hotDataCacheMissCount);
        }
        if (this.offHeapCacheUsedBytes != 0L) {
            out.writeLong(this.offHeapCacheUsedBytes);
        }
        if (this.storageStatistics != null) {
            IOUtils.writeObject(out, this.storageStatistics);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        this.cacheSize = (flags & 1) != 0 ? in.readLong() : 0L;
        this.cacheHitCount = (flags & 2) != 0 ? in.readLong() : 0L;
        this.cacheMissCount = (flags & 4) != 0 ? in.readLong() : 0L;
        this.hotDataCacheMissCount = (flags & 8) != 0 ? in.readLong() : 0L;
        long l = this.offHeapCacheUsedBytes = (flags & 0x10) != 0 ? in.readLong() : 0L;
        if ((flags & 0x20) != 0) {
            this.storageStatistics = (Collection)IOUtils.readObject(in);
        }
    }

    private int buildFlags() {
        int flags = 0;
        if (this.cacheSize != 0L) {
            flags |= 1;
        }
        if (this.cacheHitCount != 0L) {
            flags |= 2;
        }
        if (this.cacheMissCount != 0L) {
            flags |= 4;
        }
        if (this.hotDataCacheMissCount != 0L) {
            flags |= 8;
        }
        if (this.offHeapCacheUsedBytes != 0L) {
            flags |= 0x10;
        }
        if (this.storageStatistics != null) {
            flags |= 0x20;
        }
        return flags;
    }
}

