/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.server.eviction;

import com.gigaspaces.server.eviction.EvictableServerEntry;
import com.gigaspaces.server.eviction.SpaceEvictionManager;
import com.gigaspaces.server.eviction.SpaceEvictionStrategyConfig;

public abstract class SpaceEvictionStrategy {
    private SpaceEvictionManager _evictionManager;
    private SpaceEvictionStrategyConfig _evictionConfig;
    private volatile boolean _closed;

    public void initialize(SpaceEvictionManager evictionManager, SpaceEvictionStrategyConfig config) {
        this._evictionManager = evictionManager;
        this._evictionConfig = config;
    }

    public void close() {
        this._closed = true;
    }

    public boolean requiresConcurrencyProtection() {
        return true;
    }

    public void onInsert(EvictableServerEntry entry) {
    }

    public void onLoad(EvictableServerEntry entry) {
    }

    public void onRead(EvictableServerEntry entry) {
    }

    public void onUpdate(EvictableServerEntry entry) {
    }

    public void onRemove(EvictableServerEntry entry) {
    }

    public abstract int evict(int var1);

    protected SpaceEvictionManager getEvictionManager() {
        return this._evictionManager;
    }

    protected SpaceEvictionStrategyConfig getEvictionConfig() {
        return this._evictionConfig;
    }

    protected boolean isClosed() {
        return this._closed;
    }
}

