/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.server.filter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.events.NotifyContext;
import com.gigaspaces.internal.utils.ClassUtils;
import com.gigaspaces.server.filter.NotifyEvent;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.FilterProvider;
import com.j_spaces.core.filters.ISpaceFilter;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;

@InternalApi
public class NotifyAcknowledgeFilter
extends FilterProvider
implements ISpaceFilter {
    private static final long serialVersionUID = 1656923721022621158L;
    private final SpaceEngine _engine;

    public NotifyAcknowledgeFilter(SpaceEngine engine) {
        this._engine = engine;
        this.setName(ClassUtils.getShortName(this.getClass()));
        this.setEnabled(true);
        this.setOpCodes(18);
        this.setActiveWhenBackup(false);
    }

    @Override
    public ISpaceFilter getFilter() {
        return this;
    }

    @Override
    public void close() throws RuntimeException {
    }

    @Override
    public void init(IJSpace space, String filterId, String url, int priority) throws RuntimeException {
    }

    @Override
    public void process(SpaceContext context, ISpaceFilterEntry entry, int operationCode) throws RuntimeException {
        NotifyContext notifyContext = ((NotifyEvent)entry).getNotifyContext();
        if (!notifyContext.isGuaranteedNotifications()) {
            return;
        }
        OperationID opId = notifyContext.getOperationId();
        if (opId != null) {
            this._engine.getReplicationNode().outNotificationSentAndExecute(opId);
        }
    }

    @Override
    public void process(SpaceContext context, ISpaceFilterEntry[] entries, int operationCode) throws RuntimeException {
    }
}

