/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.utils;

import com.gigaspaces.annotation.SupportCodeChange;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import java.util.Collection;
import org.jini.rio.boot.SupportCodeChangeAnnotationContainer;

public class CodeChangeUtilities {
    public static void removeOneTimeClassLoaderIfNeeded(Collection objects) {
        for (Object object : objects) {
            ClassLoader oneTimeClassLoader = CodeChangeUtilities.getOneTimeClassLoader(object);
            if (oneTimeClassLoader == null) continue;
            ClassLoaderCache.getCache().removeClassLoader(oneTimeClassLoader);
        }
    }

    private static ClassLoader getOneTimeClassLoader(Object object) {
        SupportCodeChange annotation;
        if (object.getClass().isAnnotationPresent(SupportCodeChange.class) && (annotation = object.getClass().getAnnotation(SupportCodeChange.class)).id().isEmpty()) {
            return object.getClass().getClassLoader();
        }
        return null;
    }

    public static SupportCodeChangeAnnotationContainer createContainerFromSupportCodeAnnotationIfNeeded(Object object) {
        SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer = null;
        Class<?> objectClass = object.getClass();
        if (objectClass.isAnnotationPresent(SupportCodeChange.class)) {
            SupportCodeChange annotation = objectClass.getAnnotation(SupportCodeChange.class);
            supportCodeChangeAnnotationContainer = annotation.id().isEmpty() ? SupportCodeChangeAnnotationContainer.ONE_TIME : new SupportCodeChangeAnnotationContainer(annotation.id());
        }
        return supportCodeChangeAnnotationContainer;
    }
}

