/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.utils;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptorBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class CsvReader {
    private final String valuesSeparator;
    private final String metadataSeparator;
    private final Map<String, Function<String, Object>> parsers;

    public CsvReader() {
        this(new Builder());
    }

    private CsvReader(Builder builder) {
        this.valuesSeparator = builder.valuesSeparator;
        this.metadataSeparator = builder.metadataSeparator;
        this.parsers = builder.parsers;
    }

    public <T> Stream<T> read(Path path, Class<T> type) throws IOException {
        return new PojoProcessor(type).stream(path);
    }

    public Stream<SpaceDocument> read(Path path, String typeName) throws IOException {
        return this.read(path, new SpaceTypeDescriptorBuilder(typeName).create());
    }

    public Stream<SpaceDocument> read(Path path, SpaceTypeDescriptor typeDescriptor) throws IOException {
        return new DocumentProcessor(typeDescriptor).stream(path);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String valuesSeparator = ",";
        private String metadataSeparator = ":";
        private final Map<String, Function<String, Object>> parsers = Builder.initDefaultParsers();

        public Builder valuesSeparator(String valuesSeparator) {
            this.valuesSeparator = valuesSeparator;
            return this;
        }

        public Builder metadataSeparator(String metadataSeparator) {
            this.metadataSeparator = metadataSeparator;
            return this;
        }

        public Builder addParser(String typeName, Function<String, Object> parser) {
            this.parsers.put(typeName, parser);
            return this;
        }

        public CsvReader build() {
            return new CsvReader(this);
        }

        private static Map<String, Function<String, Object>> initDefaultParsers() {
            HashMap<String, Function<String, Object>> result = new HashMap<String, Function<String, Object>>();
            result.put(String.class.getName(), s -> s);
            result.put("string", s -> s);
            result.put(Boolean.TYPE.getName(), Boolean::parseBoolean);
            result.put(Boolean.class.getName(), Boolean::parseBoolean);
            result.put(Byte.TYPE.getName(), Byte::parseByte);
            result.put(Byte.class.getName(), Byte::parseByte);
            result.put(Short.TYPE.getName(), Short::parseShort);
            result.put(Short.class.getName(), Short::parseShort);
            result.put(Integer.TYPE.getName(), Integer::parseInt);
            result.put(Integer.class.getName(), Integer::parseInt);
            result.put(Long.TYPE.getName(), Long::parseLong);
            result.put(Long.class.getName(), Long::parseLong);
            result.put(Float.TYPE.getName(), Float::parseFloat);
            result.put(Float.class.getName(), Float::parseFloat);
            result.put(Double.TYPE.getName(), Double::parseDouble);
            result.put(Double.class.getName(), Double::parseDouble);
            result.put(Character.TYPE.getName(), s -> Character.valueOf(s.charAt(0)));
            result.put(Character.class.getName(), s -> Character.valueOf(s.charAt(0)));
            result.put(LocalDate.class.getName(), LocalDate::parse);
            result.put("date", LocalDate::parse);
            result.put(LocalTime.class.getName(), LocalTime::parse);
            result.put("time", LocalTime::parse);
            result.put(LocalDateTime.class.getName(), LocalDateTime::parse);
            result.put("datetime", LocalDateTime::parse);
            return result;
        }
    }

    private static class PropertyMapper {
        private final String name;
        private final Function<String, Object> parser;
        private final int pos;

        private PropertyMapper(String name, int pos, Function<String, Object> parser) {
            this.name = name;
            this.pos = pos;
            this.parser = parser;
        }
    }

    private class PojoProcessor<T>
    extends Processor<T> {
        private final SpaceTypeInfo typeInfo;

        private PojoProcessor(Class<T> type) {
            this.typeInfo = SpaceTypeInfoRepository.getTypeInfo(type);
        }

        @Override
        protected PropertyMapper initProperty(int i, String name, String typeName) {
            SpacePropertyInfo property = this.typeInfo.getProperty(name);
            if (property == null) {
                throw new IllegalArgumentException("No such property: " + name);
            }
            if (typeName == null) {
                typeName = property.getTypeName();
            }
            return new PropertyMapper(property.getName(), this.typeInfo.indexOf(property), this.getParser(typeName));
        }

        @Override
        T toEntry(String[] values) {
            Object[] allValues = new Object[this.typeInfo.getNumOfSpaceProperties()];
            for (int i = 0; i < values.length; ++i) {
                if (values[i].isEmpty()) continue;
                allValues[((PropertyMapper)this.properties[i]).pos] = this.properties[i].parser.apply(values[i]);
            }
            Object result = this.typeInfo.createInstance();
            this.typeInfo.setSpacePropertiesValues(result, allValues);
            return (T)result;
        }
    }

    private class DocumentProcessor
    extends Processor<SpaceDocument> {
        private final SpaceTypeDescriptor typeDescriptor;

        private DocumentProcessor(SpaceTypeDescriptor typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        protected PropertyMapper initProperty(int i, String name, String typeName) {
            if (typeName == null) {
                SpacePropertyDescriptor property = this.typeDescriptor.getFixedProperty(name);
                if (property == null) {
                    throw new IllegalStateException("No metadata for property " + name);
                }
                typeName = property.getTypeName();
            }
            return new PropertyMapper(name, -1, this.getParser(typeName));
        }

        @Override
        SpaceDocument toEntry(String[] values) {
            SpaceDocument result = new SpaceDocument(this.typeDescriptor.getTypeName());
            for (int i = 0; i < values.length; ++i) {
                if (values[i].isEmpty()) continue;
                result.setProperty(this.properties[i].name, this.properties[i].parser.apply(values[i]));
            }
            return result;
        }
    }

    private abstract class Processor<T> {
        protected PropertyMapper[] properties;

        private Processor() {
        }

        public Stream<T> stream(Path path) throws IOException {
            return Files.lines(path).map(line -> line.split(CsvReader.this.valuesSeparator, -1)).filter(this::filterHeader).map(this::processEntry);
        }

        private boolean filterHeader(String[] values) {
            if (this.properties == null) {
                this.properties = new PropertyMapper[values.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] tokens = values[i].split(CsvReader.this.metadataSeparator);
                    this.properties[i] = this.initProperty(i, tokens[0], tokens.length != 1 ? tokens[1] : null);
                }
                return false;
            }
            return true;
        }

        private T processEntry(String[] values) {
            if (values.length != this.properties.length) {
                throw new IllegalStateException(String.format("Inconsistent values: expected %s, actual %s", this.properties.length, values.length));
            }
            return this.toEntry(values);
        }

        abstract PropertyMapper initProperty(int var1, String var2, String var3);

        abstract T toEntry(String[] var1);

        protected Function<String, Object> getParser(String typeName) {
            Function parser = (Function)CsvReader.this.parsers.get(typeName);
            if (parser == null) {
                throw new IllegalArgumentException("No parser for type " + typeName);
            }
            return parser;
        }
    }
}

