/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.utils;

import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Pair<T, V>
implements Externalizable {
    private T first;
    private V second;

    public Pair() {
    }

    public Pair(T first, V second) {
        this.first = first;
        this.second = second;
    }

    public T getFirst() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }

    public void setFirst(T first) {
        this.first = first;
    }

    public void setSecond(V second) {
        this.second = second;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.first != null ? !this.first.equals(pair.first) : pair.first != null) {
            return false;
        }
        return this.second != null ? this.second.equals(pair.second) : pair.second == null;
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        IOUtils.writeObject(objectOutput, this.first);
        IOUtils.writeObject(objectOutput, this.second);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.first = IOUtils.readObject(objectInput);
        this.second = IOUtils.readObject(objectInput);
    }
}

