/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.AbstractQueryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractIdsQueryPacket
extends AbstractQueryPacket {
    private static final long serialVersionUID = 1L;
    protected String _className;
    protected Object[] _ids;
    protected int _version;
    private AbstractProjectionTemplate _projectionTemplate;

    public AbstractIdsQueryPacket() {
    }

    public AbstractIdsQueryPacket(Object[] ids, int version, ITypeDesc typeDesc, QueryResultTypeInternal resultType, AbstractProjectionTemplate projectionTemplate) {
        super(typeDesc, resultType);
        this._projectionTemplate = projectionTemplate;
        this._className = typeDesc.getTypeName();
        this._ids = ids;
        this._version = version;
    }

    public abstract Object getRouting(int var1);

    @Override
    public String getTypeName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public Object[] getIds() {
        return this._ids;
    }

    public void setIds(Object[] ids) {
        this._ids = ids;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public Object getID() {
        return this._ids;
    }

    @Override
    public AbstractProjectionTemplate getProjectionTemplate() {
        return this._projectionTemplate;
    }

    @Override
    public void setProjectionTemplate(AbstractProjectionTemplate projectionTemplate) {
        this._projectionTemplate = projectionTemplate;
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserialize(in, version);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserialize(in, PlatformLogicalVersion.getLogicalVersion());
    }

    private final void deserialize(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        this._className = IOUtils.readRepetitiveString(in);
        this._ids = IOUtils.readObjectArray(in);
        this._version = in.readInt();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this._projectionTemplate = (AbstractProjectionTemplate)IOUtils.readObject(in);
        }
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serialize(out, PlatformLogicalVersion.getLogicalVersion());
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serialize(out, version);
    }

    private final void serialize(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        IOUtils.writeRepetitiveString(out, this._className);
        IOUtils.writeObjectArray(out, this._ids);
        out.writeInt(this._version);
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            IOUtils.writeObject(out, this._projectionTemplate);
        }
    }

    @Override
    public boolean isIdsQuery() {
        return true;
    }
}

