/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.internal.lrmi.stubs.LRMIStubHandlerImpl;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.sadapter.datasource.DefaultSQLQueryBuilder;

public interface Constants {
    public static final String SPACE_CONFIG_PREFIX = "space-config.";
    public static final String IS_SPACE_LOAD_ON_STARTUP = "load-on-startup";

    public static interface LeaderSelector {
        public static final String LEADER_SELECTOR_HANDLER_CLASS_NAME = "org.openspaces.zookeeper.leader_selector.ZooKeeperBasedLeaderSelectorHandler";
        public static final String PREFIX = "leader-election.zookeeper.";
        public static final String SESSION_TIMEOUT = "leader-election.zookeeper.session-timeout";
        public static final String SESSION_TIMEOUT_DEFAULT = "15000";
        public static final String FULL_LEADER_SELECTOR_SESSION_TIMEOUT = "space-config.leader-election.zookeeper.session-timeout";
        public static final String CONNECTION_TIMEOUT = "leader-election.zookeeper.connection-timeout";
        public static final String CONNECTION_TIMEOUT_DEFAULT = "5000";
        public static final String FULL_LEADER_SELECTOR_CONNECTION_TIMEOUT = "space-config.leader-election.zookeeper.connection-timeout";
        public static final String RETRY_TIMEOUT = "leader-election.zookeeper.retry-timeout";
        public static final String RETRY_TIMEOUT_DEFAULT = String.valueOf(Integer.MAX_VALUE);
        public static final String FULL_LEADER_SELECTOR_RETRY_TIMEOUT = "space-config.leader-election.zookeeper.retry-timeout";
        public static final String RETRY_INTERVAL = "leader-election.zookeeper.retry-interval";
        public static final String RETRY_INTERVAL_DEFAULT = "100";
        public static final String FULL_LEADER_SELECTOR_RETRY_INTERVAL = "space-config.leader-election.zookeeper.retry-interval";
    }

    public static interface DirectPersistency {
        public static final String DIRECT_PERSISTENCY_ATTRIBURE_STORE_PROP = "directPersistency.attribute-store";
        public static final String FULL_DIRECT_PERSISTENCY_ATTRIBURE_STORE_PROP = "space-config.directPersistency.attribute-store";

        public static interface ZOOKEEPER {
            public static final String ATTRIBUET_STORE_HANDLER_CLASS_NAME = "org.openspaces.zookeeper.attribute_store.ZooKeeperAttributeStore";
        }
    }

    public static interface Security {
        public static final String PREFIX = "security.";
        public static final String USER_DETAILS = "security.userDetails";
        public static final String CREDENTIALS_PROVIDER = "security.credentials-provider";
        public static final String USERNAME = "security.username";
        public static final String PASSWORD = "security.password";
    }

    public static interface SpaceProxy {
        public static final String PREFIX = "space-config.proxy.";

        public static interface OldRouter {
            public static final String PREFIX = "proxy-settings.";
            public static final String RETRY_CONNECTION = "retries";
            public static final String RETRY_CONNECTION_DEFAULT = "10";
            public static final String RETRY_CONNECTION_FULL = "space-config.retries";
            public static final String CONNECTION_MONITOR = "proxy-settings.connection-monitor";
            public static final String CONNECTION_MONITOR_DEFAULT = "all";
            public static final String CONNECTION_MONITOR_FULL = "space-config.proxy-settings.connection-monitor";
            public static final String MONITOR_FREQUENCY = "proxy-settings.ping-frequency";
            public static final String MONITOR_FREQUENCY_DEFAULT = System.getProperty("com.gs.cluster.livenessMonitorFrequency", String.valueOf(10000L));
            public static final String MONITOR_FREQUENCY_FULL = "space-config.proxy-settings.ping-frequency";
            public static final String DETECTOR_FREQUENCY = "proxy-settings.lookup-frequency";
            public static final String DETECTOR_FREQUENCY_DEFAULT = System.getProperty("com.gs.cluster.livenessDetectorFrequency", String.valueOf(5000L));
            public static final String DETECTOR_FREQUENCY_FULL = "space-config.proxy-settings.lookup-frequency";
            public static final String CONNECTION_RETRIES = "proxy-settings.connection-retries";
            public static final String CONNECTION_RETRIES_DEFAULT = "10";
            public static final String CONNECTION_RETRIES_FULL = "space-config.proxy-settings.connection-retries";
        }

        public static interface Router {
            public static final String PREFIX = "space-config.proxy.router.";
            public static final String ACTIVE_SERVER_LOOKUP_TIMEOUT = "space-config.proxy.router.active-server-lookup-timeout";
            public static final long ACTIVE_SERVER_LOOKUP_TIMEOUT_DEFAULT = 20000L;
            public static final String ACTIVE_SERVER_LOOKUP_SAMPLING_INTERVAL = "space-config.proxy.router.active-server-lookup-sampling-interval";
            public static final long ACTIVE_SERVER_LOOKUP_SAMPLING_INTERVAL_DEFAULT = 100L;
            public static final String THREAD_POOL_SIZE = "space-config.proxy.router.threadpool-size";
            public static final String LOAD_BALANCER_TYPE = "space-config.proxy.router.load-balancer-type";
        }

        public static interface Events {
            public static final String PREFIX = "space-config.proxy.events.";
            public static final String REGISTRATION_DURATION = "space-config.proxy.events.registration-duration";
            public static final long REGISTRATION_DURATION_DEFAULT = 30000L;
            public static final String REGISTRATION_RENEW_INTERVAL = "space-config.proxy.events.registration-renew-interval";
            public static final long REGISTRATION_RENEW_INTERVAL_DEFAULT = 10000L;
        }
    }

    public static interface Statistics {
        public static final String STATISTICS_FILTER_NAME = "Statistics";
        public static final long DEFAULT_PERIOD = 10000L;
    }

    public static interface WorkerManager {
        public static final String WORKER_PREFIX = "workers.";
        public static final String IS_INTERRUPT_THREADS_ON_SHUTDOWN = "workers.interrupt";
        public static final String WORKER_NAMES_PROP = "workers.worker-names";
        public static final String WORKER_ENABLED = "enabled";
        public static final String WORKER_ACTIVE_WHEN_BACKUP = "active-when-backup";
        public static final String WORKER_CLASSNAME = "class-name";
        public static final String WORKER_SHUTDOWN_ON_INIT_FAILURE = "shutdown-space-on-init-failure";
        public static final String WORKER_INSTANCES = "instances";
        public static final String WORKER_ARG = "arg";
        public static final String WORKER_DESCRIPTION = "description";
        public static final String DEFAULT_WORKER_ENABLED = "true";
        public static final String DEFAULT_WORKER_ACTIVE_WHEN_BACKUP = "true";
        public static final String DEFAULT_WORKER_SHUTDOWN_ON_INIT_FAILURE = "false";
        public static final String DEFAULT_WORKER_INSTANCES = "1";
    }

    public static interface Cluster {
        public static final String IS_CLUSTER_SPACE_PROP = "cluster.enabled";
        public static final String FULL_IS_CLUSTER_SPACE_PROP = "space-config.cluster.enabled";
        public static final String IS_CLUSTER_SPACE_DEFAULT = Boolean.FALSE.toString();
        public static final String CLUSTER_CONFIG_URL_PROP = "cluster.config-url";
        public static final String FULL_CLUSTER_CONFIG_URL_PROP = "space-config.cluster.config-url";
        public static final String CLUSTER_CONFIG_URL_DEFAULT = "none";
    }

    public static interface DCache {
        public static final String SPACE_SUFFIX = "_DCache";
        public static final String FILE_SUFFIX_EXTENTION = "_DCache.xml";
        public static final String DCACHE_CONFIG_NAME_DEFAULT = "DefaultConfig";
        public static final String DCACHE_CONFIG_FILE_DEFAULT = "DefaultConfig_DCache.xml";
        public static final String DIST_CACHE_PREFIX = "dist-cache.";
        public static final String CONFIG_NAME_PROP = "dist-cache.config-name";
        public static final String FULL_DCACHE_CONFIG_NAME_PROP = "space-config.dist-cache.config-name";
        public static final String UPDATE_MODE_PROP = "dist-cache.update-mode";
        public static final String UPDATE_MODE_DEFUALT = Integer.toString(1);
        public static final String STORAGE_TYPE_PROP = "dist-cache.storage-type";
        public static final String STORAGE_TYPE_DEFAULT = "reference";
        public static final String VERSIONED_PROP = "dist-cache.versioned";
        public static final String VERSIONED_DEFUALT = "false";
        public static final String MAX_OBJECT_TIMEOUT_PROP = "dist-cache.max-object-timeout";
        public static final String RETRY_CONNECTIONS_PROP = "dist-cache.retry-connections";
        public static final String DELAY_BETWEEN_RETRIES_PROP = "dist-cache.delay-between-retries";
        public static final String EVICTION_STRATEGY_PROP = "dist-cache.eviction-strategy";
        public static final String EVICTION_STRATEGY_DEFUALT = "com.j_spaces.map.eviction.FIFOEvictionStrategy";
        public static final String PUT_FIRST_PROP = "dist-cache.put-first";
        public static final String PUT_FIRST_DEFUALT = "true";
        public static final String COMPRESSION_PROP = "dist-cache.compression";
        public static final String COMPRESSION_DEFUALT = "0";
    }

    public static interface CacheManager {
        public static final int CACHE_POLICY_LRU = 0;
        public static final int CACHE_POLICY_ALL_IN_CACHE = 1;
        public static final int CACHE_POLICY_PLUGGED_EVICTION = 2;
        public static final int CACHE_POLICY_BLOB_STORE = 3;
        public static final int MAX_CACHE_POLICY_VALUE = 3;
        public static final String CACHE_MANAGER_SIZE_DEFAULT = "100000";
        public static final String CACHE_MANAGER_SIZE_PROP = "engine.cache_size";
        public static final String FULL_CACHE_MANAGER_SIZE_PROP = "space-config.engine.cache_size";
        public static final String CACHE_POLICY_PROP = "engine.cache_policy";
        public static final String FULL_CACHE_POLICY_PROP = "space-config.engine.cache_policy";
        public static final String CACHE_MANAGER_EVICTION_STRATEGY_CLASS_PROP = "engine.eviction_strategy";
        public static final String CACHE_MANAGER_EVICTION_STRATEGY_PROP = "engine.eviction_strategy_instance";
        public static final String CACHE_MANAGER_BLOBSTORE_STORAGE_HANDLER_CLASS_PROP = "engine.blobstore_storage_handler";
        public static final String CACHE_MANAGER_BLOBSTORE_STORAGE_HANDLER_PROP = "engine.blobstore_storage_handler_instance";
        public static final String BLOBSTORE_ENABLE_UNSAFE_ENDPOINT_PROP = "blobstore.enable_unsafe_sync_endpoint";
        public static final String FULL_BLOBSTORE_ENABLE_UNSAFE_ENDPOINT_PROP = "space-config.blobstore.enable_unsafe_sync_endpoint";
        public static final String CACHE_MANAGER_BLOBSTORE_PERSISTENT_PROP = "engine.blobstore_persistent";
        public static final String FULL_CACHE_MANAGER_BLOBSTORE_PERSISTENT_PROP = "space-config.engine.blobstore_persistent";
        public static final String CACHE_MANAGER_BLOBSTORE_CACHE_FILTER_QUERIES_PROP = "engine.blobstore_cache_filter_queries";
        public static final String FULL_CACHE_MANAGER_BLOBSTORE_CACHE_FILTER_QUERIES_PROP = "space-config.engine.blobstore_cache_filter_queries";
        public static final String CACHE_MANAGER_USE_BLOBSTORE_BULKS_PROP = "engine.blobstore_use_bulks";
        public static final String FULL_CACHE_MANAGER_USE_BLOBSTORE_BULKS_PROP = "space-config.engine.blobstore_use_bulks";
        public static final String CACHE_MANAGER_USE_BLOBSTORE_CLEAR_OPTIMIZATION_PROP = "engine.blobstore_use_clear_optimization";
        public static final String FULL_CACHE_MANAGER_USE_BLOBSTORE_CLEAR_OPTIMIZATION_PROP = "space-config.engine.blobstore_use_clear_optimization";
        public static final String CACHE_MANAGER_BLOBSTORE_CACHE_SIZE_PROP = "engine.blobstore_cache_size";
        public static final String FULL_CACHE_MANAGER_BLOBSTORE_CACHE_SIZE_PROP = "space-config.engine.blobstore_cache_size";
        public static final String CACHE_MANAGER_BLOBSTORE_CACHE_SIZE_DELAULT = "10000";
        public static final String CACHE_MANAGER_BLOBSTORE_PREFETCH_MIN_THREADS_PROP = "engine.blobstore_prefetch_min_threads";
        public static final String FULL_CACHE_MANAGER_BLOBSTORE_PREFETCH_MIN_THREADS_PROP = "space-config.engine.blobstore_prefetch_min_threads";
        public static final int CACHE_MANAGER_BLOBSTORE_PREFETCH_MIN_THREADS_DEFAULT = 0;
        public static final String CACHE_MANAGER_BLOBSTORE_PREFETCH_MAX_THREADS_PROP = "engine.blobstore_prefetch_max_threads";
        public static final String FULL_CACHE_MANAGER_BLOBSTORE_PREFETCH_MAX_THREADS_PROP = "space-config.engine.blobstore_prefetch_max_threads";
        public static final int CACHE_MANAGER_BLOBSTORE_PREFETCH_MAX_THREADS_DEFAULT = 16;
        public static final String CACHE_MANAGER_BOLBSTORE_USE_PREFETCH_PROP = "engine.blobstore_prefetch";
        public static final String FULL_CACHE_MANAGER_BOLBSTORE_USE_PREFETCH_PROP = "space-config.engine.blobstore_prefetch";
        public static final String CACHE_MANAGER_BLOBSTORE_DEVICES_PROP = "blobStoreDevices";
        public static final String CACHE_MANAGER_BLOBSTORE_CAPACITY_GB_PROP = "blobStoreCapacityGB";
        public static final String CACHE_MANAGER_BLOBSTORE_CAPACITY_GB_DEFAULT = "200";
        public static final String CACHE_MANAGER_BLOBSTORE_CACHE_CAPACITY_MB_PROP = "blobStoreCacheSizeMB";
        public static final String CACHE_MANAGER_BLOBSTORE_CACHE_CAPACITY_MB_DEFAULT = "100";
        public static final String CACHE_MANAGER_BLOBSTORE_CACHE_DURABILITY_LEVEL_PROP = "blobStoreDurabilityLevel";
        public static final String CACHE_MANAGER_BLOBSTORE_VOLUME_DIR_PROP = "blobStoreVolumeDir";
        public static final String BLOBSTORE_MEMORY_USAGE_WRITE_ONLY_BLOCK_PRECENTAGE_DEFAULT = "80";
        public static final String BLOBSTORE_OFF_HEAP_MIN_DIFF_TO_ALLOCATE_PROP = "blobstore.off-heap.update_threshold";
        public static final String BLOBSTORE_OFF_HEAP_MIN_DIFF_TO_ALLOCATE_DEFAULT_VALUE = "50B";
        public static final String CACHE_MANAGER_INITIAL_LOAD_DEFAULT = "50";
        public static final String CACHE_MANAGER_INITIAL_LOAD_PROP = "engine.initial_load";
        public static final String FULL_CACHE_MANAGER_INITIAL_LOAD_PROP = "space-config.engine.initial_load";
        public static final String CACHE_MANAGER_INITIAL_LOAD_CLASS_PROP = "engine.initial_load_class";
        public static final String CACHE_MANAGER_MIN_EXTENDED_INDEX_ACTIVATION_DEFAULT = "1";
        public static final String CACHE_MANAGER_MIN_EXTENDED_INDEX_ACTIVATION_PROP = "engine.extended-match.min_ext_index_activation_size";
        public static final int PERSISTENT_GC_INTERVAL_DEFAULT = 300000;
        public static final String PERSISTENT_GC_INTERVAL_PROP = "lease_manager.expiration_time_interval";
        public static final String CACHE_MANAGER_LRU_TOUCH_THRESHOLD_PROP = "engine.lruTouchThreshold";
        public static final String CACHE_MANAGER_LRU_TOUCH_THRESHOLD_DEFAULT = "50";
        public static final String CACHE_MANAGER_EVICTABLE_LOCKS_SIZE_PROP = "engine.EvictableLocksSize";
        public static final String CACHE_MANAGER_EVICTABLE_LOCKS_SIZE_DEFAULT = "2000";
        public static final String CACHE_MANAGER_USE_ECONOMY_HASHMAP_PROP = "engine.use_economy_hashmap";
        public static final String CACHE_MANAGER_USE_ECONOMY_HASHMAP_DEFAULT = "false";
        public static final String CACHE_MANAGER_PARTIAL_UPDATE_REPLICATION_PROP = "engine.partial_update_replication";
        public static final String CACHE_MANAGER_PARTIAL_UPDATE_REPLICATION_DEFAULT = "true";
        public static final int CACHE_MANAGER_TIMEBASED_EVICTION_MEMORY_TIME_DEFAULT = 86400000;
        public static final String CACHE_MANAGER_TIMEBASED_EVICTION_MEMORY_TIME_PROP = "engine.time_based_eviction_memory_time";
        public static final int CACHE_MANAGER_TIMEBASED_EVICTION_REINSERTED_MEMORY_TIME_DEFAULT = 0;
        public static final String CACHE_MANAGER_TIMEBASED_EVICTION_REINSERTED_MEMORY_TIME_PROP = "engine.time_based_eviction_reinserted_memory_time";
        public static final int CACHE_MANAGER_SYNC_LIST_THREAD_INTERVAL_TIME_DEFAULT = 500;
        public static final String CACHE_MANAGER_SYNC_LIST_THREAD_INTERVAL_TIME_PROP = "engine.sync_list_thread_interval_time";
        public static final int CACHE_MANAGER_SYNC_LIST_MAX_SIZE_IN_MEMORY_DEFAULT = 100000;
        public static final String CACHE_MANAGER_SYNC_LIST_MAX_SIZE_IN_MEMORY_PROP = "engine.sync_list_max_size_in_memory";
        public static final String FULL_CACHE_MANAGER_SYNC_LIST_MAX_SIZE_IN_MEMORY_PROP = "space-config.engine.sync_list_max_size_in_memory";
        public static final String CACHE_MANAGER_FORCE_ID_INDEX_PROP = "engine.cache.force-space-id-index-if-equal";
    }

    public static interface DataAdapter {
        public static final String DATA_ADAPTER_PREFIX = "external-data-source.";
        public static final String DATA_SOURCE = "external-data-source.data-source";
        public static final String SPACE_DATA_SOURCE = "external-data-source.space-data-source";
        public static final String SPACE_DATA_SOURCE_CLASS = "external-data-source.space-data-source-class";
        public static final String SPACE_SYNC_ENDPOINT = "external-data-source.space-sync-endpoint";
        public static final String SPACE_SYNC_ENDPOINT_CLASS = "external-data-source.space-sync-endpoint-class";
        public static final String DATA_SOURCE_CLASS_PROP = "external-data-source.data-source-class";
        public static final String DATA_SOURCE_CLASS_DEFAULT = "org.openspaces.persistency.hibernate.DefaultHibernateExternalDataSource";
        public static final String DATA_CLASS_PROP = "external-data-source.data-class";
        public static final String DATA_CLASS_DEFAULT = Object.class.getName();
        public static final String QUERY_BUILDER_PROP = "external-data-source.query-builder-class";
        public static final String QUERY_BUILDER_PROP_DEFAULT = DefaultSQLQueryBuilder.class.getName();
        public static final String USAGE = "external-data-source.usage";
        public static final String USAGE_DEFAULT = "read-write";
        public static final String SUPPORTS_INHERITANCE_PROP = "external-data-source.supports-inheritance";
        public static final String SUPPORTS_INHERITANCE_DEFAULT = "true";
        public static final String SUPPORTS_VERSION_PROP = "external-data-source.supports-version";
        public static final String SUPPORTS_VERSION_DEFAULT = "false";
        public static final String SUPPORTS_PARTIAL_UPDATE_PROP = "external-data-source.supports-partial-update";
        public static final String SUPPORTS_PARTIAL_UPDATE_DEFAULT = "false";
        public static final String SUPPORTS_REMOVE_BY_ID_PROP = "external-data-source.supports-remove-by-id";
        public static final String SUPPORTS_REMOVE_BY_ID_DEFAULT = "false";
        public static final String DATA_PROPERTIES = "external-data-source.init-properties-file";
        public static final String DATA_PROPERTIES_DEFAULT = "";
        public static final String SHARED_ITERATOR_PREFIX = "external-data-source.shared-iterator.";
        public static final String DATA_SOURCE_SHARE_ITERATOR_ENABLED_PROP = "external-data-source.shared-iterator.enabled";
        public static final String DATA_SOURCE_SHARE_ITERATOR_ENABLED_DEFAULT = "true";
        public static final String DATA_SOURCE_SHARE_ITERATOR_TTL_PROP = "external-data-source.shared-iterator.time-to-live";
    }

    public static interface StorageAdapter {
        public static final String SPACE_PERSISTENT_PREFIX = "persistent.";
        public static final String XARESOURCE_TIMEOUT = "xaresource_timeout";
        public static final String PERSISTENT_ENABLED = "enabled";
        public static final String PERSISTENT_ENABLED_PROP = "persistent.enabled";
        public static final String PERSISTENT_ENABLED_DEFAULT = Boolean.FALSE.toString();
        public static final String FULL_STORAGE_PERSISTENT_ENABLED_PROP = "space-config.persistent.enabled";
        public static final String DIRECT_PERSISTENCY_LAST_PRIMARY_STATE_PATH_PROP = "com.gs.DirectPersistencyLastPrimaryStatePath";
    }

    public static interface LRMIStubHandler {
        public static final String PROTOCOL_RMI = "RMI";
        public static final String PROTOCOL_NIO = "NIO";
        public static final String LRMI_DEFAULT_STUB_HANDLER_CLASS = LRMIStubHandlerImpl.class.getName();
        public static final String LRMI_DEFAULT_PROTOCOL = "NIO";
    }

    public static interface SystemTime {
        public static final String SYSTEM_TIME_PROVIDER_PROP = "com.j_spaces.kernel.time-provider";
    }

    public static interface LeaseManager {
        public static final long LM_EXPIRATION_TIME_INTERVAL_DEFAULT = 10000L;
        public static final long LM_BACKUP_EXPIRATION_DELAY_DEFAULT = 300000L;
        public static final long LM_EXPIRATION_TIME_STALE_REPLICAS_DEFAULT = 300000L;
        public static final long LM_EXPIRATION_TIME_PENDING_ANSWERS_DEFAULT = 60000L;
        public static final long LM_EXPIRATION_TIME_RECENT_DELETES_DEFAULT = 180000L;
        public static final long LM_EXPIRATION_TIME_RECENT_UPDATES_DEFAULT = 180000L;
        public static final long LM_EXPIRATION_TIME_RECENT_DELETES_CHECK_DEFAULT = 5000L;
        public static final long LM_EXPIRATION_TIME_RECENT_UPDATES_CHECK_DEFAULT = 5000L;
        public static final long LM_CHECK_TIME_MARKERS_REPOSITORY_DEFAULT = 5000L;
        public static final long LM_EXPIRATION_TIME_FIFOENTRY_XTNINFO = 60000L;
        public static final int LM_EXPIRATION_TIME_UNUSED_TXN_DEFAULT = 5000;
        public static final int LM_SEGMEENTS_PER_EXPIRATION_CELL_DEFAULT = 2;
        public static final boolean LM_DISABLE_ENTRIES_LEASES_DEFAULT = false;
        public static final String LM_EXPIRATION_TIME_UNUSED_TXN_PROP = "lease_manager.expiration_unused_txns";
        public static final String LM_DISABLE_ENTRIES_LEASES_PROP = "lease_manager.disable_entries_leases";
        public static final String LM_EXPIRATION_TIME_STALE_REPLICAS_PROP = "lease_manager.expiration_stale_replicas";
        public static final String FULL_LM_EXPIRATION_TIME_STALE_REPLICAS_PROP = "space-config.lease_manager.expiration_stale_replicas";
        public static final String LM_EXPIRATION_TIME_RECENT_DELETES_PROP = "lease_manager.expiration_time_recent_deletes";
        public static final String FULL_LM_EXPIRATION_TIME_RECENT_DELETES_PROP = "space-config.lease_manager.expiration_time_recent_deletes";
        public static final String LM_EXPIRATION_TIME_RECENT_UPDATES_PROP = "lease_manager.expiration_time_recent_updates";
        public static final String FULL_LM_EXPIRATION_TIME_RECENT_UPDATES_PROP = "space-config.lease_manager.expiration_time_recent_updates";
        public static final String LM_EXPIRATION_TIME_INTERVAL_PROP = "lease_manager.expiration_time_interval";
        public static final String FULL_LM_EXPIRATION_TIME_INTERVAL_PROP = "space-config.lease_manager.expiration_time_interval";
        public static final String LM_BACKUP_EXPIRATION_DELAY_PROP = "lease_manager.backup_leases_expiration_delay";
        public static final String LM_SEGMEENTS_PER_EXPIRATION_CELL_PROP = "lease_manager.segments_per_expiration_cell";
    }

    public static interface RemoteCode {
        public static final String REMOTE_CODE = "remote-code";
        public static final String REMOTE_CODE_MAX_CLASS_LOADERS = "remote-code.max-class-loaders";
        public static final String REMOTE_CODE_MAX_CLASS_LOADERS_DEFAULT = "3";
        public static final String FULL_REMOTE_CODE_MAX_CLASS_LOADERS_PROP = "space-config.remote-code.max-class-loaders";
        public static final String REMOTE_CODE_SUPPORT_CODE_CHANGE = "remote-code.support.code.change";
        public static final String REMOTE_CODE_SUPPORT_CODE_CHANGE_DEFAULT = "true";
        public static final String FULL_REMOTE_CODE_SUPPORT_CODE_CHANGE_PROP = "space-config.remote-code.support.code.change";
    }

    public static interface SqlFunction {
        public static final String USER_SQL_FUNCTION = "user-sql-function";
    }

    public static interface Filter {
        public static final String FILTERS_TAG_NAME = "filters";
        public static final String FILTER_NAMES_TAG_NAME = "filter-names";
        public static final String FILTER_PROVIDERS = "filter-providers";
        public static final String FILTER_NAMES_PROP = "filters.filter-names";
        public static final String FILTER_ACTIVE_WHEN_BACKUP = "active-when-backup";
        public static final String FILTER_SHUTDOWN_ON_INIT_FAILURE = "shutdown-space-on-init-failure";
        public static final String FILTER_ENABLED_TAG_NAME = "enabled";
        public static final String FILTER_CLASS_TAG_NAME = "class";
        public static final String FILTER_OPERATION_CODE_TAG_NAME = "operation-code";
        public static final String FILTER_URL_TAG_NAME = "url";
        public static final String FILTER_PRIORITY_TAG_NAME = "priority";
        public static final String FILTER_PASS_ENTRY = "pass-filter-entry";
        @Deprecated
        public static final String DEFAULT_FILTER_SECURITY_NAME = "DefaultSecurityFilter";
        public static final String DEFAULT_ACTIVE_WHEN_BACKUP = String.valueOf(true);
        public static final String DEFAULT_SHUTDOWN_ON_INIT_FAILURE = String.valueOf(false);
        public static final String DEFAULT_FILTER_ENABLE_VALUE = String.valueOf(true);
        public static final String DEFAULT_OPERATION_CODE_VALUE = "";
        public static final String DEFAULT_PASS_ENTRY = String.valueOf(true);
    }

    public static interface ReplicationFilter {
        public static final String REPLICATION_FILTER_PROVIDER = "replication-filter-provider";
    }

    public static interface Replication {
        public static final String GATEWAY_PROXY = "gateway-proxy";
    }

    public static interface Engine {
        public static final int NOTIFIER_TIME_LIMIT = 2000;
        public static final long UPDATE_NO_LEASE = 0L;
        public static final String ENGINE_MIN_THREADS_PROP = "engine.min_threads";
        public static final String ENGINE_MIN_THREADS_DEFAULT = "1";
        public static final String FULL_ENGINE_MIN_THREADS_PROP = "space-config.engine.min_threads";
        public static final String ENGINE_MAX_THREADS_PROP = "engine.max_threads";
        public static final String ENGINE_MAX_THREADS_DEFAULT = "64";
        public static final String FULL_ENGINE_MAX_THREADS_PROP = "space-config.engine.max_threads";
        public static final String ENGINE_NOTIFY_MIN_THREADS_DEFAULT = "1";
        public static final String ENGINE_NOTIFY_MAX_THREADS_DEFAULT = "64";
        public static final String ENGINE_NOTIFY_MIN_THREADS_PROP = "engine.notify_min_threads";
        public static final String ENGINE_NOTIFY_MAX_THREADS_PROP = "engine.notify_max_threads";
        public static final String ENGINE_THREADS_HIGHER_PRIORITY_PROP = "engine.threads_higher_priority";
        public static final String ENGINE_DIRTY_READ_DEFAULT = "false";
        public static final String ENGINE_DIRTY_READ_PROP = "engine.dirty_read";
        public static final String ENGINE_LOCAL_CACHE_MODE_DEFAULT = "false";
        public static final String ENGINE_LOCAL_CACHE_MODE_PROP = "engine.local_cache_mode";
        public static final String ENGINE_MEMORY_USAGE_ENABLED_DEFAULT = "true";
        public static final String ENGINE_MEMORY_USAGE_ENABLED_PRIMARY_ONLY = "primary-only";
        public static final String ENGINE_MEMORY_USAGE_ENABLED_PROP = "engine.memory_usage.enabled";
        public static final String FULL_ENGINE_MEMORY_USAGE_ENABLED_PROP = "space-config.engine.memory_usage.enabled";
        public static final String ENGINE_MEMORY_USAGE_HIGH_PERCENTAGE_RATIO_DEFAULT = "95";
        public static final String ENGINE_MEMORY_USAGE_HIGH_PERCENTAGE_RATIO_PROP = "engine.memory_usage.high_watermark_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_HIGH_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.high_watermark_percentage";
        public static final String ENGINE_MEMORY_USAGE_SYNCHRONUS_EVICTION_WATERMARK_DEFAULT = "0";
        public static final String ENGINE_MEMORY_USAGE_SYNCHRONUS_EVICTION_WATERMARK_PROP = "engine.memory_usage.synchronous_eviction_watermark_percentage";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_BLOCK_PERCENTAGE_RATIO_DEFAULT = "85";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_BLOCK_PERCENTAGE_RATIO_PROP = "engine.memory_usage.write_only_block_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_WR_ONLY_BLOCK_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.write_only_block_percentage";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_CHECK_PERCENTAGE_RATIO_DEFAULT = "76";
        public static final String ENGINE_MEMORY_USAGE_WR_ONLY_CHECK_PERCENTAGE_RATIO_PROP = "engine.memory_usage.write_only_check_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_WR_ONLY_CHECK_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.write_only_check_percentage";
        public static final String ENGINE_MEMORY_USAGE_LOW_PERCENTAGE_RATIO_DEFAULT = "75";
        public static final String ENGINE_MEMORY_USAGE_LOW_PERCENTAGE_RATIO_PROP = "engine.memory_usage.low_watermark_percentage";
        public static final String FULL_ENGINE_MEMORY_USAGE_LOW_PERCENTAGE_RATIO_PROP = "space-config.engine.memory_usage.low_watermark_percentage";
        public static final String ENGINE_MEMORY_USAGE_EVICTION_BATCH_SIZE_DEFAULT = "500";
        public static final String ENGINE_MEMORY_USAGE_EVICTION_BATCH_SIZE_PROP = "engine.memory_usage.eviction_batch_size";
        public static final String FULL_ENGINE_MEMORY_USAGE_EVICTION_BATCH_SIZE_PROP = "space-config.engine.memory_usage.eviction_batch_size";
        public static final String ENGINE_MEMORY_USAGE_RETRY_COUNT_DEFAULT = "5";
        public static final String ENGINE_MEMORY_USAGE_RETRY_COUNT_PROP = "engine.memory_usage.retry_count";
        public static final String FULL_ENGINE_MEMORY_USAGE_RETRY_COUNT_PROP = "space-config.engine.memory_usage.retry_count";
        public static final String ENGINE_MEMORY_USAGE_RETRY_YIELD_DEFAULT = "50";
        public static final String ENGINE_MEMORY_USAGE_RETRY_YIELD_PROP = "engine.memory_usage.retry_yield_time";
        public static final String ENGINE_MEMORY_EXPLICIT_GC_DEFAULT = "false";
        public static final String ENGINE_MEMORY_EXPLICIT_GC_PROP = "engine.memory_usage.explicit-gc";
        public static final String FULL_ENGINE_MEMORY_EXPLICIT_GC_PROP = "space-config.engine.memory_usage.explicit-gc";
        public static final String ENGINE_MEMORY_GC_BEFORE_MEMORY_SHORTAGE_DEFAULT = "true";
        public static final String ENGINE_MEMORY_GC_BEFORE_MEMORY_SHORTAGE_PROP = "engine.memory_usage.gc-before-shortage";
        public static final String FULL_ENGINE_MEMORY_GC_BEFORE_MEMORY_SHORTAGE_PROP = "space-config.engine.memory_usage.gc-before-shortage";
        public static final String ENGINE_MEMORY_EXPLICIT_LEASE_REAPER_DEFAULT = "true";
        public static final String ENGINE_MEMORY_EXPLICIT_LEASE_REAPER_PROP = "engine.memory_usage.explicit-lease-reaper";
        public static final String ENGINE_SERIALIZATION_TYPE_DEFAULT = String.valueOf(StorageType.OBJECT.getCode());
        public static final String ENGINE_SERIALIZATION_TYPE_PROP = "serialization-type";
        public static final String FULL_ENGINE_SERIALIZATION_TYPE_PROP = "space-config.serialization-type";
        public static final String ENGINE_NOTIFIER_RETRIES_DEFAULT = "3";
        public static final String ENGINE_NOTIFIER_TTL_PROP = "notifier-retries";
        public static final String FULL_ENGINE_NOTIFIER_TTL_PROP = "space-config.notifier-retries";
        public static final String ENGINE_REGULAR_EXPRESSIONS_CACHE_SIZE_PROP = "engine.extended-match.regular-expressions-cache-size";
        public static final String ENGINE_REGULAR_EXPRESSIONS_CACHE_SIZE_DEFAULT = "300";
        public static final String ENGINE_INSERT_SHORT_LEASE_RETRY_PROP = "engine.insert_short_lease_retry";
        public static final String ENGINE_INSERT_SHORT_LEASE_RETRY_DEFAULT = "3";
        public static final String ENGINE_FIFO_NOTIFY_THREADS_PROP = "engine.fifo_notify_threads";
        public static final String ENGINE_FIFO_NOTIFY_THREADS_DEFAULT = "0";
        public static final String ENGINE_FIFO_REGULAR_THREADS_PROP = "engine.fifo_regular_threads";
        public static final String ENGINE_FIFO_REGULAR_THREADS_DEFAULT = "4";
        public static final String ENGINE_NON_BLOCKING_READ_PROP = "engine.non_blocking_read";
        public static final String ENGINE_NON_BLOCKING_READ_DEFAULT = "true";
        public static final String ENGINE_CLEAN_UNUSED_EMBEDDED_GLOBAL_XTNS_PROP = "engine.clean_unused_embedded_global_xtns";
        public static final String ENGINE_CLEAN_UNUSED_EMBEDDED_GLOBAL_XTNS_DEFAULT = "true";
        public static final String ENGINE_QUERY_RESULT_SIZE_LIMIT = "engine.query.result.size.limit";
        public static final String ENGINE_QUERY_RESULT_SIZE_LIMIT_DEFAULT = "0";
        public static final String ENGINE_QUERY_RESULT_SIZE_LIMIT_MEMORY_CHECK_BATCH_SIZE = "engine.query.result.size.limit.memory.check.batch.size";
        public static final String ENGINE_QUERY_RESULT_SIZE_LIMIT_MEMORY_CHECK_BATCH_SIZE_DEFAULT = "0";
        public static final String ENGINE_DEMOTE_MIN_TIMEOUT = "engine.demote.min-timeout";
        public static final String ENGINE_DEMOTE_MIN_TIMEOUT_DEFAULT = "5s";
        public static final String ENGINE_DEMOTE_COMPLETION_EVENT_TIMEOUT = "engine.demote.completion-event-timeout";
        public static final String ENGINE_DEMOTE_COMPLETION_EVENT_TIMEOUT_DEFAULT = "5s";
    }

    public static interface Management {
        public static final String JMX_MBEAN_DESCRIPTORS_CONTAINER = "ContainerMBeanDescriptors.xml";
        public static final String JMX_MBEAN_DESCRIPTORS_JAVASPACE = "JavaSpaceMBeanDescriptors.xml";
        public static final String JMX_MBEAN_DESCRIPTORS_JAVASPACE_EXT = "JavaSpaceExtMBeanDescriptors.xml";
    }

    public static interface Jms {
        public static final String JMS_DELIMITER = ";";
        public static final String JMS_CONFIG_FILE_NAME = "jms-config.xml";
        public static final String JMS_CONFIG_DIRECTORY = "config/jms/";
        public static final String JMS_RMI_PORT_PROP = "jms.connections.rmi-port";
        public static final String JMS_RMI_PORT_DEFAULT = "10098";
        public static final String JMS_TOPIC_NAMES_PROP = "jms.administrated-destinations.topics.topic-names";
        public static final String JMS_QUEUE_NAMES_PROP = "jms.administrated-destinations.queues.queue-names";
        public static final String FULL_JMS_QUEUE_NAMES_PROP = "space-config.jms.administrated-destinations.queues.queue-names";
        public static final String FULL_JMS_RMI_PORT_PROP = "space-config.jms.connections.rmi-port";
        public static final String FULL_JMS_TOPIC_NAMES_PROP = "space-config.jms.administrated-destinations.topics.topic-names";
        public static final String JMS_QUEUE_NAMES_DEFAULT = "MyQueue,TempQueue";
        public static final String JMS_TOPIC_NAMES_DEFAULT = "MyTopic,TempTopic";
        public static final String JMS_JMS_NAME = "jms";
        public static final String JMS_DESTINATIONS_NAME = "destinations";
        public static final String JMS_CON_FAC_NAME = "GSConnectionFactoryImpl";
        public static final String JMS_TOPIC_CON_FAC_NAME = "GSTopicConnectionFactoryImpl";
        public static final String JMS_XATOPIC_CON_FAC_NAME = "GSXATopicConnectionFactoryImpl";
        public static final String JMS_QUEUE_CON_FAC_NAME = "GSQueueConnectionFactoryImpl";
        public static final String JMS_XAQUEUE_CON_FAC_NAME = "GSXAQueueConnectionFactoryImpl";
    }

    public static interface LookupManager {
        public static final String MANUFACTURE = "GigaSpaces Technologies Ltd.";
        public static final String VENDOR = "GigaSpaces";
        public static final String PUBLIC = "public";
        public static final String PUBLIC_GROUP = "";
        public static final String NONE_GROUP = "none";
        public static final String ALL_GROUP = "all";
        public static final String LOOKUP_ENABLED_DEFAULT = "true";
        public static final String START_EMBEDDED_LOOKUP_DEFAULT = "true";
        public static final String LOOKUP_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jini_lus.enabled";
        public static final String START_EMBEDDED_LOOKUP_PROP = "com.j_spaces.core.container.directory_services.jini_lus.start-embedded-lus";
        public static final String LOOKUP_GROUP_PROP = "com.j_spaces.core.container.directory_services.jini_lus.groups";
        public static final String LOOKUP_UNICAST_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_UNICAST_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.enabled";
        public static final String LOOKUP_UNICAST_URL_DEFAULT = "";
        public static final String LOOKUP_UNICAST_URL_PROP = "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host";
        public static final String LOOKUP_JNDI_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JNDI_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jndi.enabled";
        public static final String LOOKUP_JNDI_URL_DEFAULT = "localhost:10098";
        public static final String LOOKUP_JNDI_URL_PROP = "com.j_spaces.core.container.directory_services.jndi.url";
        public static final String LOOKUP_JMS_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JMS_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jms_services.enabled";
        public static final String LOOKUP_JMS_INTERNAL_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JMS_INTERNAL_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jms_services.internal-jndi.internal-jndi-enabled";
        public static final String LOOKUP_JMS_EXT_ENABLED_DEFAULT = "false";
        public static final String LOOKUP_JMS_EXT_ENABLED_PROP = "com.j_spaces.core.container.directory_services.jms_services.ext-jndi.ext-jndi-enabled";
        public static final String LOOKUP_IS_PRIVATE_PROP = "isPrivate";
        public static final String FULL_LOOKUP_IS_PRIVATE_PROP = "space-config.isPrivate";
        public static final String LOOKUP_IS_PRIVATE_DEFAULT = Boolean.FALSE.toString();
    }

    public static interface QueryProcessorInfo {
        public static final String PREFIX = "QueryProcessor.";
        public static final String QP_SPACE_READ_LEASE_TIME = "space_read_lease_time";
        public static final String QP_SPACE_READ_LEASE_TIME_DEFAULT = String.valueOf(0);
        public static final String QP_SPACE_READ_LEASE_TIME_PROP = "QueryProcessor.space_read_lease_time";
        public static final String FULL_QP_SPACE_READ_LEASE_TIME_PROP = "space-config.QueryProcessor.space_read_lease_time";
        public static final String QP_SPACE_WRITE_LEASE = "space_write_lease";
        public static final long lease = Long.MAX_VALUE;
        public static final String QP_SPACE_WRITE_LEASE_DEFAULT = String.valueOf(Long.MAX_VALUE);
        public static final String QP_SPACE_WRITE_LEASE_PROP = "QueryProcessor.space_write_lease";
        public static final String FULL_QP_SPACE_WRITE_LEASE_PROP = "space-config.QueryProcessor.space_write_lease";
        public static final String QP_TRANSACTION_TIMEOUT = "transaction_timeout";
        public static final String QP_TRANSACTION_TIMEOUT_DEFAULT = String.valueOf(30000);
        public static final String QP_TRANSACTION_TIMEOUT_PROP = "QueryProcessor.transaction_timeout";
        public static final String FULL_QP_TRANSACTION_TIMEOUT_PROP = "space-config.QueryProcessor.transaction_timeout";
        public static final String QP_TRANSACTION_TYPE = "gs.tx_manager_type";
        public static final String QP_TRANSACTION_TYPE_DISTRIBUTED;
        public static final String QP_TRANSACTION_TYPE_DEFAULT;
        public static final String QP_LOOKUP_TRANSACTION_NAME = "gs.lookup_tx.name";
        public static final String QP_LOOKUP_TRANSACTION_NAME_DEFAULT;
        public static final String QP_LOOKUP_TRANSACTION_TIMEOUT = "gs.lookup_tx.timeout";
        public static final long QP_LOOKUP_TRANSACTION_TIMEOUT_DEFAULT = 3000L;
        public static final String QP_LOOKUP_TRANSACTION_GROUPS = "gs.lookup_tx.groups";
        public static final String QP_LOOKUP_TRANSACTION_LOCATORS = "gs.lookup_tx.locators";
        public static final String QP_LOOKUP_TRANSACTION_LOCATORS_DEFAULT;
        public static final String QP_TRACE_EXEC_TIME = "trace_exec_time";
        public static final String QP_TRACE_EXEC_TIME_DEFAULT;
        public static final String QP_TRACE_EXEC_TIME_PROP = "QueryProcessor.trace_exec_time";
        public static final String FULL_QP_TRACE_EXEC_TIME_PROP = "space-config.QueryProcessor.trace_exec_time";
        public static final String QP_PARSER_CASE_SENSETIVITY = "parser_case_sensetivity";
        public static final String QP_PARSER_CASE_SENSETIVITY_DEFAULT;
        public static final String QP_PARSER_CASE_SENSETIVITY_PROP = "QueryProcessor.parser_case_sensetivity";
        public static final String FULL_QP_PARSER_CASE_SENSETIVITY_PROP = "space-config.QueryProcessor.parser_case_sensetivity";
        public static final String QP_AUTO_COMMIT = "auto_commit";
        public static final String QP_AUTO_COMMIT_DEFAULT;
        public static final String QP_AUTO_COMMIT_PROP = "QueryProcessor.auto_commit";
        public static final String FULL_QP_AUTO_COMMIT_PROP = "space-config.QueryProcessor.auto_commit";
        public static final String QP_DATE_FORMAT = "date_format";
        public static final String QP_DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
        public static final String QP_DATE_FORMAT_PROP = "QueryProcessor.date_format";
        public static final String FULL_QP_DATE_FORMAT_PROP = "space-config.QueryProcessor.date_format";
        public static final String QP_DATETIME_FORMAT = "datetime_format";
        public static final String QP_DATETIME_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
        public static final String QP_DATETIME_FORMAT_PROP = "QueryProcessor.datetime_format";
        public static final String FULL_QP_DATETIME_FORMAT_PROP = "space-config.QueryProcessor.datetime_format";
        public static final String QP_TIME_FORMAT = "time_format";
        public static final String QP_TIME_FORMAT_DEFAULT = "HH:mm:ss";
        public static final String QP_TIME_FORMAT_PROP = "QueryProcessor.time_format";
        public static final String FULL_QP_TIME_FORMAT_PROP = "space-config.QueryProcessor.time_format";

        static {
            QP_TRANSACTION_TYPE_DEFAULT = QP_TRANSACTION_TYPE_DISTRIBUTED = ITransactionManagerProvider.TransactionManagerType.DISTRIBUTED.getNameInConfiguration();
            QP_LOOKUP_TRANSACTION_NAME_DEFAULT = null;
            QP_LOOKUP_TRANSACTION_LOCATORS_DEFAULT = null;
            QP_TRACE_EXEC_TIME_DEFAULT = String.valueOf(false);
            QP_PARSER_CASE_SENSETIVITY_DEFAULT = String.valueOf(true);
            QP_AUTO_COMMIT_DEFAULT = String.valueOf(true);
        }
    }

    public static interface Space {
        public static final String FULL_SPACE_STATE = "space-config.space_state";
        public static final String SPACE_CONFIG = "space-config";
    }

    public static interface Mirror {
        public static final String MIRROR_SERVICE_PREFIX = "mirror-service.";
        public static final String MIRROR_SERVICE_ENABLED_PROP = "mirror-service.enabled";
        public static final String MIRROR_SERVICE_ENABLED_DEFAULT = "false";
        public static final String FULL_MIRROR_SERVICE_ENABLED_PROP = "space-config.mirror-service.enabled";
        public static final String MIRROR_SERVICE_OPERATION_GROUPING_TAG = "mirror-service.operation-grouping";
        public static final String FULL_MIRROR_SERVICE_OPERATION_GROUPING_TAG = "space-config.mirror-service.operation-grouping";
        public static final String MIRROR_IMPORT_DIRECTORY_TAG = "mirror-service.import-directory";
        public static final String FULL_MIRROR_IMPORT_DIRECTORY_TAG = "space-config.mirror-service.import-directory";
        public static final String GROUP_BY_SPACE_TRANSACTION_TAG_VALUE = "group-by-space-transaction";
        public static final String GROUP_BY_REPLICATION_BULK_TAG_VALUE = "group-by-replication-bulk";
        public static final String MIRROR_SERVICE_OPERATION_GROUPING_DEFAULT_VALUE = "group-by-replication-bulk";
        public static final String MIRROR_SERVICE_CLUSTER_NAME = "mirror-service.cluster.name";
        public static final String FULL_MIRROR_SERVICE_CLUSTER_NAME = "space-config.mirror-service.cluster.name";
        public static final String MIRROR_SERVICE_CLUSTER_PARTITIONS_COUNT = "mirror-service.cluster.partitions";
        public static final String FULL_MIRROR_SERVICE_CLUSTER_PARTITIONS_COUNT = "space-config.mirror-service.cluster.partitions";
        public static final String MIRROR_SERVICE_CLUSTER_BACKUPS_PER_PARTITION = "mirror-service.cluster.backups-per-partition";
        public static final String FULL_MIRROR_SERVICE_CLUSTER_BACKUPS_PER_PARTITION = "space-config.mirror-service.cluster.backups-per-partition";
        public static final String MIRROR_DISTRIBUTED_TRANSACTION_PROCESSING_PARAMETERS = "mirror-service.distributed-transaction-processing.";
        public static final String MIRROR_DISTRIBUTED_TRANSACTION_TIMEOUT = "mirror-service.distributed-transaction-processing.wait-timeout";
        public static final String FULL_MIRROR_DISTRIBUTED_TRANSACTION_TIMEOUT = "space-config.mirror-service.distributed-transaction-processing.wait-timeout";
        public static final String MIRROR_DISTRIBUTED_TRANSACTION_WAIT_FOR_OPERATIONS = "mirror-service.distributed-transaction-processing.wait-for-operations";
        public static final String FULL_MIRROR_DISTRIBUTED_TRANSACTION_WAIT_FOR_OPERATIONS = "space-config.mirror-service.distributed-transaction-processing.wait-for-operations";
        public static final String MIRROR_DISTRIBUTED_TRANSACTION_MONITOR_PENDING_OPERATIONS_MEMORY = "mirror-service.distributed-transaction-processing.monitor-pending-operations-memory";
    }

    public static interface Container {
        public static final String PREFIX = "com.j_spaces.core.container.";
        public static final String CONTAINER_CONFIG_DIRECTORY = "config";
        public static final String CONTAINER_CONFIG_FILE_SUFFIX = "-config.xml";
        public static final String CONTAINER_NAME_PROP = "com.j_spaces.core.container.name";
        public static final String CONTAINER_SHUTDOWN_HOOK_PROP = "com.j_spaces.core.container.shutdown_hook";
        public static final String CONTAINER_SHUTDOWN_HOOK_PROP_DEFAULT = "true";
        public static final String CONTAINER_EMBEDDED_MAHALO_ENABLED_PROP = "com.j_spaces.core.container.embedded-services.mahalo.start-embedded-mahalo";
        public static final String CONTAINER_EMBEDDED_MAHALO_ENABLED_DEFAULT = "false";
    }

    public static interface Schemas {
        public static final String SCHEMA_ELEMENT = "schema";
        public static final String FULL_SCHEMA_ELEMENT = "space-config.schema";
        public static final String SCHEMAS_FOLDER = "schemas";
        public static final String DEFAULT_SCHEMA = "default";
        public static final String PERSISTENT_SCHEMA = "persistent";
        public static final String MIRROR_SCHEMA = "mirror";
        public static final String CACHE_SCHEMA = "cache";
        public static final String JAVASPACE_SCHEMA = "javaspace";
        public static final String SPACE_SCHEMA_FILE_SUFFIX = "-space-schema.xml";
        public static final String CONTAINER_SCHEMA_FILE_SUFFIX = "-container-schema.xml";
        public static final String SCHEMA_FILE_PATH = "schemaFilePath";
    }
}

