/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.ReplaceInFileUtils;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.kernel.ResourceLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;

@InternalApi
public class ContainerConfigFactory {
    public static void performSaveAs(String schemaPrefixFileName, String selFilePath, ContainerConfig containerConfig) {
        try {
            File fileWithDefaultConfiguration = ContainerConfigFactory.createContainerSchemaFile(schemaPrefixFileName, selFilePath);
            ContainerConfigFactory.updateFile(containerConfig, fileWithDefaultConfiguration.getPath(), schemaPrefixFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File createContainerSchemaFile(String schemaPrefixFileName, String containerSchemaFilePath) throws RemoteException {
        File defaultSchemaFile = null;
        try {
            String schemaFilePath = "config/schemas/default-container-schema.xml";
            InputStream schemaInputStream = ResourceLoader.getResourceStream(schemaFilePath);
            String folderOwnerPath = containerSchemaFilePath.substring(0, containerSchemaFilePath.lastIndexOf(File.separator));
            File folderOwnerInstance = new File(folderOwnerPath);
            if (!folderOwnerInstance.exists()) {
                folderOwnerInstance.mkdirs();
            }
            defaultSchemaFile = new File(containerSchemaFilePath);
            FileOutputStream fos = new FileOutputStream(defaultSchemaFile);
            int read = 1;
            while (read > 0) {
                byte[] readBytesArray = new byte[schemaInputStream.available()];
                read = schemaInputStream.read(readBytesArray);
                fos.write(readBytesArray);
            }
            fos.flush();
            fos.close();
            schemaInputStream.close();
            ReplaceInFileUtils file = new ReplaceInFileUtils(containerSchemaFilePath);
            file.replaceInFile("<default>", "<" + schemaPrefixFileName + ">");
            file.replaceInFile("</default>", "</" + schemaPrefixFileName + ">");
            file.close();
        }
        catch (Exception ex) {
            throw new RemoteException("Fail to create schema file", ex);
        }
        return defaultSchemaFile;
    }

    public static void updateFile(ContainerConfig config, String containerConfigURL, String schemaPrefixFileName) throws IOException {
        ReplaceInFileUtils containerFile = new ReplaceInFileUtils(containerConfigURL);
        containerFile.xmlReplace("com.j_spaces.core.container.name", schemaPrefixFileName);
        containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jini_lus.enabled", String.valueOf(config.isJiniLusEnabled()));
        containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jndi.enabled", String.valueOf(config.isJndiEnabled()));
        if (config.jndiUrl != null) {
            containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jndi.url", config.jndiUrl);
        }
        if (config.lookupGroups != null) {
            containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jini_lus.groups", config.lookupGroups);
        }
        containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.enabled", String.valueOf(config.unicastEnabled));
        if (config.unicastURL != null) {
            containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host", config.unicastURL);
        }
        containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jms_services.enabled", String.valueOf(config.jmsEnabled));
        containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jms_services.internal-jndi.internal-jndi-enabled", String.valueOf(config.jmsInternalJndiEnabled));
        containerFile.xmlReplace("com.j_spaces.core.container.directory_services.jms_services.ext-jndi.ext-jndi-enabled", String.valueOf(config.jmsExtJndiEnabled));
        containerFile.close();
    }

    public static String getContainerSchemaPathName(String containerName) {
        StringBuilder result = new StringBuilder();
        result.append(SystemInfo.singleton().locations().config());
        result.append(File.separator);
        result.append("schemas");
        result.append(File.separator);
        result.append(containerName);
        result.append("-container-schema.xml");
        return result.toString();
    }
}

