/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.ContainerConfigFactory;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InternalApi
public class ContainerXML {
    public static final String TAG_CONTAINER = "container";
    public static final String TAG_CONTAINER_ADMIN_NAME = "admin-name";
    public static final String TAG_CONTAINER_ADMIN_PASSWORD = "admin-password";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.config");

    public static void setAdmin(boolean useSchema, String containerName, String adminName, String adminPassword) throws Exception {
        ContainerXML.setTags(useSchema, new String[]{TAG_CONTAINER_ADMIN_NAME, TAG_CONTAINER_ADMIN_PASSWORD}, new String[]{adminName, adminPassword}, TAG_CONTAINER, containerName);
    }

    private static Document getRootDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document rootDocument = domBuilder.parse(xmlFile);
        JSpaceUtilities.normalize(rootDocument);
        return rootDocument;
    }

    private static String getContainerConfigPathName(String containerName) {
        StringBuilder result = new StringBuilder();
        result.append(SystemInfo.singleton().locations().config());
        result.append(File.separator);
        result.append(containerName);
        result.append("-config.xml");
        return result.toString();
    }

    private static Node createTextNode(Document rootDoc, String tagName, String tagValue) {
        Element tag = rootDoc.createElement(tagName);
        Text tagText = rootDoc.createTextNode(tagValue);
        tag.appendChild(tagText);
        return tag;
    }

    private static synchronized void saveXML(Element rootElement, File containerFile) throws IOException {
        block4: {
            try {
                String filePath = containerFile.getCanonicalPath();
                String filePathWithoutExtention = filePath.substring(0, filePath.lastIndexOf(46));
                File oldFile = new File(filePathWithoutExtention + ".old");
                if (oldFile.exists()) {
                    oldFile.delete();
                } else {
                    containerFile.renameTo(oldFile);
                }
                PrintStream attrStream = new PrintStream(new FileOutputStream(filePath));
                JSpaceUtilities.domWriter(rootElement, attrStream, "");
                attrStream.close();
            }
            catch (FileNotFoundException ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, "FileNotFoundException: " + ex.toString(), ex);
            }
        }
    }

    private static void setTags(boolean useSchema, String[] tagName, String[] tagValue, String parentTag, String containerName) throws Exception {
        File containerConfigFile;
        File file = containerConfigFile = useSchema ? new File(ContainerConfigFactory.getContainerSchemaPathName(containerName)) : new File(ContainerXML.getContainerConfigPathName(containerName));
        if (useSchema && !containerConfigFile.exists()) {
            ContainerConfigFactory.createContainerSchemaFile(containerName, containerConfigFile.getPath());
        }
        Document rootDocument = ContainerXML.getRootDocument(containerConfigFile);
        Element containerElem = (Element)rootDocument.getElementsByTagName(parentTag).item(0);
        Element elem = null;
        for (int i = 0; i < tagName.length; ++i) {
            if (containerElem.getElementsByTagName(tagName[i]).getLength() > 0) {
                elem = (Element)containerElem.getElementsByTagName(tagName[i]).item(0);
                elem.getChildNodes().item(0).setNodeValue(tagValue[i]);
                continue;
            }
            containerElem.appendChild(ContainerXML.createTextNode(rootDocument, tagName[i], tagValue[i]));
        }
        ContainerXML.saveXML(rootDocument.getDocumentElement(), containerConfigFile);
    }
}

