/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.transport.EntryPacket;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.client.ExternalEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ExternalEntryPacket
extends EntryPacket {
    private static final long serialVersionUID = 1L;
    protected String _implClassName;

    public ExternalEntryPacket() {
    }

    public ExternalEntryPacket(ITypeDesc typeDesc, Object[] values) {
        super(typeDesc, values);
    }

    public ExternalEntryPacket(ITypeDesc typeDesc, EntryType entryType, Object[] fixedProperties, String uid, int version, long timeToLive, boolean isTransient) {
        super(typeDesc, entryType, fixedProperties, null, uid, version, timeToLive, isTransient);
    }

    public ExternalEntryPacket(ITypeDesc typeDesc, EntryType entryType, Object[] fixedProperties, String uid, int version, long timeToLive, boolean isTransient, String implClassName) {
        super(typeDesc, entryType, fixedProperties, null, uid, version, timeToLive, isTransient);
        this._implClassName = implClassName;
    }

    @Override
    public TransportPacketType getPacketType() {
        return TransportPacketType.ENTRY_PACKET;
    }

    @Override
    public String getExternalEntryImplClassName() {
        return this._implClassName;
    }

    @Override
    public Object toObject(EntryType entryType, StorageTypeDeserialization storageTypeDeserialization) {
        try {
            if (this._typeDesc != null) {
                return super.toObject(entryType, storageTypeDeserialization);
            }
            if (this.getMultipleUIDs() != null) {
                return new ExternalEntry(this.getMultipleUIDs());
            }
            return new ExternalEntry(this.getUID());
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serializePacket(out);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserializePacket(in);
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serializePacket(out);
    }

    private final void serializePacket(ObjectOutput out) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if (this._implClassName != null) {
            IOUtils.writeString(out, this._implClassName);
        }
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserializePacket(in);
    }

    private final void deserializePacket(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if ((flags & 2) != 0) {
            this._implClassName = IOUtils.readString(in);
        }
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this._implClassName != null) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }

    private static interface BitMap {
        public static final byte IMPL_CLASSNAME = 2;
    }
}

