/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ObjectShortMap;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.ExternalEntryPacket;
import com.j_spaces.core.client.ExternalEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

@InternalApi
public class ExternalTemplatePacket
extends ExternalEntryPacket
implements ITemplatePacket {
    private static final long serialVersionUID = 1L;
    protected short[] _extendedMatchCodes;
    protected Object[] _rangeValues;
    protected boolean[] _rangeValuesInclusion;

    public ExternalTemplatePacket() {
    }

    public ExternalTemplatePacket(ITypeDesc typeDesc, EntryType entryType, Object[] values, String uid, int version, long timeToLive, boolean isTransient, ExternalEntry ee) {
        super(typeDesc, entryType, values, uid, version, timeToLive, isTransient);
        if (ee != null) {
            Class<?> realClz = ee.getClass();
            this._implClassName = realClz.equals(ExternalEntry.class) ? null : realClz.getName();
            this._entryType = ee._returnTrueType ? entryType : EntryType.EXTERNAL_ENTRY;
            this._returnOnlyUIDs = ee.m_ReturnOnlyUids;
            this._extendedMatchCodes = this.getOrderedExtMatchCodes(ee);
            this._rangeValues = this.getOrderedExtRangeValues(ee);
            this._rangeValuesInclusion = this.getOrderedExtRangeValuesInclusion(ee);
        }
    }

    @Override
    public QueryResultTypeInternal getQueryResultType() {
        return QueryResultTypeInternal.fromEntryType(this._entryType);
    }

    @Override
    public Object getRoutingFieldValue() {
        int pos = this._typeDesc.getRoutingPropertyId();
        if (pos != -1 && this._extendedMatchCodes != null && this._extendedMatchCodes[pos] != 0) {
            return null;
        }
        return super.getRoutingFieldValue();
    }

    @Override
    public boolean supportExtendedMatching() {
        return this._extendedMatchCodes != null || this._rangeValues != null || this._rangeValuesInclusion != null;
    }

    @Override
    public short[] getExtendedMatchCodes() {
        return this._extendedMatchCodes;
    }

    @Override
    public Object[] getRangeValues() {
        return this._rangeValues;
    }

    @Override
    public boolean[] getRangeValuesInclusion() {
        return this._rangeValuesInclusion;
    }

    private short[] getOrderedExtMatchCodes(ExternalEntry ee) {
        short[] extendedMatchCodes = ee.m_ExtendedMatchCodes;
        if (extendedMatchCodes == null) {
            return null;
        }
        String[] fieldsNames = ee.getFieldsNames();
        if (fieldsNames == null) {
            if (this._typeDesc.getNumOfFixedProperties() != extendedMatchCodes.length) {
                throw new ConversionException(new IllegalArgumentException("Original fields count does not match the size of extendedMatchCode"));
            }
            return extendedMatchCodes;
        }
        ObjectShortMap<String> fieldsNamesToCodes = CollectionsFactory.getInstance().createObjectShortMap();
        for (int i = 0; i < fieldsNames.length; ++i) {
            fieldsNamesToCodes.put(fieldsNames[i], extendedMatchCodes[i]);
        }
        short[] newMatchCodes = new short[this._typeDesc.getNumOfFixedProperties()];
        for (int i = 0; i < newMatchCodes.length; ++i) {
            String fieldName = this._typeDesc.getFixedProperty(i).getName();
            if (!fieldsNamesToCodes.containsKey(fieldName)) continue;
            newMatchCodes[i] = fieldsNamesToCodes.get(fieldName);
        }
        return newMatchCodes;
    }

    private Object[] getOrderedExtRangeValues(ExternalEntry ee) {
        Object[] rangeValues = ee.m_RangeValues;
        if (rangeValues == null) {
            return null;
        }
        HashMap<String, Object> fieldNamesToRange = new HashMap<String, Object>();
        for (int i = 0; i < ee.m_FieldsNames.length; ++i) {
            fieldNamesToRange.put(ee.m_FieldsNames[i], rangeValues[i]);
        }
        Object[] newRangeValue = new Object[this._typeDesc.getNumOfFixedProperties()];
        for (int i = 0; i < newRangeValue.length; ++i) {
            newRangeValue[i] = fieldNamesToRange.get(this._typeDesc.getFixedProperty(i).getName());
        }
        return newRangeValue;
    }

    private boolean[] getOrderedExtRangeValuesInclusion(ExternalEntry ee) {
        boolean[] rangeValues = ee.m_RangeValuesInclusion;
        if (rangeValues == null) {
            return null;
        }
        HashMap<String, Boolean> fieldNamesToInclusions = new HashMap<String, Boolean>();
        for (int i = 0; i < ee.m_FieldsNames.length; ++i) {
            fieldNamesToInclusions.put(ee.m_FieldsNames[i], rangeValues[i]);
        }
        boolean[] newRangeValue = new boolean[this._typeDesc.getNumOfFixedProperties()];
        for (int i = 0; i < newRangeValue.length; ++i) {
            Boolean include = (Boolean)fieldNamesToInclusions.get(this._typeDesc.getFixedProperty(i).getName());
            newRangeValue[i] = include != null ? include : false;
        }
        return newRangeValue;
    }

    @Override
    public ExternalTemplatePacket clone() {
        return (ExternalTemplatePacket)super.clone();
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serializePacket(out);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserializePacket(in);
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serializePacket(out);
    }

    private final void serializePacket(ObjectOutput out) throws IOException {
        IOUtils.writeShortArray(out, this._extendedMatchCodes);
        IOUtils.writeObjectArray(out, this._rangeValues);
        IOUtils.writeBooleanArray(out, this._rangeValuesInclusion);
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserializePacket(in);
    }

    private final void deserializePacket(ObjectInput in) throws IOException, ClassNotFoundException {
        this._extendedMatchCodes = IOUtils.readShortArray(in);
        this._rangeValues = IOUtils.readObjectArray(in);
        this._rangeValuesInclusion = IOUtils.readBooleanArray(in);
    }

    @Override
    public void validate() {
        this.validateStorageType();
    }

    @Override
    public AbstractProjectionTemplate getProjectionTemplate() {
        return null;
    }

    @Override
    public void setProjectionTemplate(AbstractProjectionTemplate projectionTemplate) {
    }

    @Override
    public boolean isIdQuery() {
        return false;
    }

    @Override
    public boolean isIdsQuery() {
        return false;
    }

    @Override
    public boolean isTemplateQuery() {
        return false;
    }

    @Override
    public boolean isAllIndexValuesSqlQuery() {
        return false;
    }
}

