/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import java.util.Comparator;

@InternalApi
public class FifoEntriesComparator
implements Comparator<IEntryHolder> {
    @Override
    public int compare(IEntryHolder o1, IEntryHolder o2) {
        int res = this.compare_impl(o1, o2);
        if (res != 0) {
            return res;
        }
        if (o1 != o2 && o1.getServerTypeDesc() == o2.getServerTypeDesc() && !o1.getUID().equals(o2.getUID())) {
            throw new RuntimeException("invalid fifo order 2 equal entries from same class uid1=" + o1.getUID() + " uid2=" + o2.getUID());
        }
        return o1.getUID().compareTo(o2.getUID());
    }

    private int compare_impl(IEntryHolder o1, IEntryHolder o2) {
        if (o1.getSCN() < o2.getSCN()) {
            return -1;
        }
        if (o1.getSCN() > o2.getSCN()) {
            return 1;
        }
        return o1.getOrder() - o2.getOrder();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FifoEntriesComparator;
    }
}

